#!/usr/bin/env bash
set -euo pipefail

# Usage: ./init_getd_dirs.sh [/path/to/base]
# Default base: /data/data123/lifang/dockerb
BASE="${1:-/data/data123/lifang/dockerb}"

echo "Base directory: $BASE"

# Root output folder
mkdir -p "$BASE/data"

# Subdirectories to create under $BASE/data
dirs=(
  ALEXI_LAI
  ALEXI_LST
  ALEXI_MET
  ALEXI_SNOW
  CFS
  CFS_COMMON
  climo
  ESI
  ET
  EVI
  GOES/EAST
  GOES/WEST
  GOESBTP/EAST
  GOESBTP/WEST
  GOESLSTP/EAST
  GOESLSTP/WEST
  GSIP/UTP
  LST/EAST
  LST/WEST
  product
  SNOWMASK
  tmp
  TRAD/EAST
  TRAD/WEST
  weekly_evi
)

for d in "${dirs[@]}"; do
  mkdir -p "$BASE/data/$d"
done

echo "Created ${#dirs[@]} subdirectories under $BASE/data"
