#! /bin/csh -f     
# The C-SHELL script performs one day GETD processing 
#
# 1. Process all the input raw data into ALEXI input domain.
#   1.1 GFS meteorological data
#    a. Process the GFS meteorological data into common 
#       grid in UTC time.
#    b. Extract the GFS data into NA domain and generate
#       the two morning time variables for ALEXI model.
#       This step requires two days of UTC data to generate
#       a full day 24 hours meteorological data in local time.
#
#   1.2 GOES data     
#    a. The process requires the IDL program to generate the
#       GOES data remap the GOES EAST and WEST data
#       into 4-km grid.
#    b. Run run_daily_GOES_STEP1.csh to generate the clear
#       sky surface radiance and cloud mask for EAST and WEST.
#    c. Using MET data and TRAD to do the atmospheric correction
#       to get land surface temperature (LST).
#    d. Combine the GOES EAST and WEST data into one single domain.
#
#   1.3 VIIRS LAI processing
#    a. The process requires the VIIRS EVI processing program
#       to run and generate the global EVI data in binary format.
#    b. 
#       LAI is extracted to the NA domain.
#   1.4 Snowmask processing
#       Snow mask is extracted to the NA domain.
#
# 2. Compute the daily ET using ALEXI.
#
# 3. Post processing of the ALEXI ET
#   3.1 Compute the ESI
#   3.3 Run post processing steps to generate the final products.
#
# Main loop  

# Path to compiled executables inside the container
if ( ! $?BIN_DIR ) then
  setenv BIN_DIR /app/run
endif

# Set up the loop time start and end day
if( $#argv != 4 ) then
  echo "Usage: $0 [Year_BEGIN] [Year_END] [DOY_BEGIN] [DOY_END]"
  echo DOY is 3 digits
  echo $0 2014 2015 1 365
  goto error
endif
# save command line args in variables
set beginyear = $1
set endyear = $2
set begindoy = $3
set enddoy = $4

set in_year = $1

while ($in_year <= $endyear )

set iday = $3

while ($iday <= $enddoy)

if ( $iday < 1 ) then
  echo Input day: $iday is invalid
  goto error
endif

set next_year = $in_year
set next_day = $iday

set leap_flag = 0
# Check for leap year
# set leap_flag = 0
  if ( $in_year % 4 == 0 ) then
    if ( $in_year % 100 != 0 ) then
      @ leap_flag = 1
    else
      if ( $in_year % 400 == 0 ) then
        @ leap_flag = 1
      endif
    endif
  endif #Check Leap Year

if ( $leap_flag == 1 ) then

  if (  $iday < 366 ) then
    @ next_day = $iday + 1
  else
  # End of year, the next day is the
  # new year's day
    @ next_year = $in_year + 1
    @ next_day = 1
  endif

else

  if (  $iday < 365 ) then
    @ next_day = $iday + 1
  else
  # End of year, the next day is the
  # new year's day
    @ next_year = $in_year + 1
    @ next_day = 1
  endif

endif

echo Next day: $next_year, $next_day

# Make sure the day of the year is 3 digits.

if ( $iday < 10 ) then
  set idoy = "00"$iday
else if ( $iday < 100 ) then
  set idoy = "0"$iday
else
  set idoy = $iday
endif


if ( $next_day < 10 ) then
  set next_day_3 = "00"$next_day
else if ( $next_day < 100 ) then
  set next_day_3 = "0"$next_day
else
  set next_day_3 = $next_day
endif

set pre_year = $in_year
set prev_doy = $iday

  if (  $iday > 1 ) then
    @ prev_doy = $iday - 1
  else
    @ pre_year = $in_year - 1
    @ prev_doy = 365
  endif

if ( $prev_doy < 10 ) then
  set prev_day = "00"$prev_doy
else if ( $prev_doy < 100 ) then
  set prev_day = "0"$prev_doy
else
  set prev_day = $prev_doy
endif

  echo Convert input DOY to month and day
  set dummy = `$BIN_DIR/month_day.x $in_year $iday`
  set mm = $dummy[1]
  set dd = $dummy[2]
  echo Convert $iday into Month $mm Day $dd
  set month = $mm
  set day = $dd

# Record the time to start
#
set t1=`date +%s`

TIME_step:
echo "run $SCRIPT_DIR/run_daily_SUNTIMES.csh $in_year $iday"
echo "SCRIPT_DIR = $SCRIPT_DIR"
echo "GETD_ALEXI_MET = $GETD_ALEXI_MET"

$SCRIPT_DIR/run_daily_SUNTIMES.csh $in_year $iday


  set t2=`date +%s`
  set tmin
@ tmin = ( $t2 - $t1 ) / 60
echo "Data processing time is" $tmin "min"

@ iday ++

end

@ in_year ++

end


done:
  exit 0

error:
  exit 1

