/* BEGIN JPSS HEADER */
/*****************************************************************************
*
* Peraton, Inc.  All rights reserved.
*
* GOVERNMENT RIGHTS:
* Per contract 1332KP23CNEEJ0001, CAR 1352.227-70 applies giving full
* copyrights to data, including reports and other copyrighted materials
* to the United States Government.
*
* THIRD PARTY RIGHTS:
* Note: Third party entities may own copyrights in this work.
*
* EXPORT CONTROL:
* Unless otherwise specified beneath this header, this item does not contain
* Technology or Technical Data controlled under either the U.S. International
* Traffic in Arms Regulations or the U.S. Export Administration Regulations.
*
* CLASSIFICATION: B
* Refer to Software Standards and Practices Manual (SSPM) for coding and
* documentation standards.
*
*****************************************************************************/
/* END JPSS HEADER */

/*****************************************************************************
*
*  NAME: ScienceDataRecordStatus.h
*
*  DESCRIPTION:   See description preceeding declaration below
*
*****************************************************************************/

/***********************************************************************
*  HISTORY:
*  
* DATE        PR#      AUTHOR            Build    DESCRIPTION
* ---------   ---      ------            -----    -----------
* 25Apr2005            Bryan Henderson     1.3    Initial Version
*                      Dan Elliott
*                      Tim Hahn
* 01Mar2006            Dan Elliott         1.4    Fringe Count Error
*                      Tim Hahn                   Follow On Drop
* 02Aug2006  011858    Dan Elliott         1.4    Modified ITT header with
*                                                 permission from Steven G.
*                                                 Minnie from ITT Space
*                                                 Systems, LLC
* 07Jan2008   15748    Bryan Henderson    1.5.x.1 ISTN_CRIS_SDR_NGST_1.1
*                                                 drop implementation
*                                                 ref. NP-EMD-2007.510.0027
*                                                 RevB
* 03Feb2010   21718    K. Boswell        SensChar ISTN_CRIS_SDR_UNIX_NGST_2.2
*                                                 drop implementation
*                                                 per TM NP-EMD.2009.510.0046
* 25JUN2014            Y. Chen/Y.Han      Mx8.5   Add variable calibrationOrder
* 14OCT2014  042555    SEClark         Blk2.0.0.4 CrIS SSPM Compliance. 
* 03JAN2015   41268    J. Eberle         Blk2.0   Header Changes
* 11MAY2015   48586    T. Gardner        Blk2.0   Integrate TR/FR updates into
*                                                 block 2.0
***********************************************************************/

/*******************************************************************************
* This document contains information proprietary and confidential to ITT Space 
* Systems, LLC ("ITT"), or a third party for whom ITT may have a legal 
* obligation to protect such information from unauthorized disclosure, use or
* duplication. Any disclosure, use, duplication or diversion contrary
* to U.S. Law of this document or of any of the information contained herein 
* for other than the
* specific purpose for which it was disclosed is expressly prohibited, 
* except as ITT has otherwise
* agreed in writing or as the U.S. Government has authorized. All copies of 
* this document are the
* sole property of ITT and will be returned promptly upon request
******************************************************************************/

#ifndef _INC_SDRStatusRecord_INCLUDED
#define _INC_SDRStatusRecord_INCLUDED

#include <Typedefs.h>

typedef struct
{
   UInt16                              algorithmnVersionNumber;
   bool                                invalidData;
   bool                                fringeCountErrorDetected;
   bool                                fringeCountErrorCorrected;
   bool                                fringeCountErrorCorrectionFailure;
   bool                                fringeCountErrorExcessive;
   bool                                invalidSpectralCalibration;
   bool                                invalidNeonCalibration;
   bool                                thermalDriftExcessive;
   bool                                excessiveNEdN;
   bool                                invalidSpectralResampling;
   bool                                invalidGeolocation;
   UInt8                               apodizationType;
   UInt8                               calibrationOrder;
   bool                                spare;
   SpectralCalibrationMethod           calibrationType;
   Int16                               hotCalTargetSignificance;
   Int16                               coldCalTargetSignificance;
   Float64                             laserWavelength;
   Float64                             losElevationAngle;
   Float64                             losRollAngle;
   Float64                             losYawAngle;
   Float64                             losPitchAngle;
   Float64                             sateliteZenithAngle;
   Float64                             sateliteAzimuthAngle;
   Float64                             sunZenithAngle;
   Float64                             sunAzimuthAngle;
   Float64                             sateliteAltitude;
   Float64                             range;
   Float64                             longitude;
   Float64                             latitude;
   Float32                             majorXAxisFootprint;
   Float32                             minorXAxisFootprint;
   Float64                             spectralResamplingLaserWavelength;
   Float64                             monitoredLaserWavelength;
   Int32                               sdrFringeCount;
   bool                                lunarIntrusionDetected;
   bool                                linearityCorrMode;
   Float64                             Vdc;
   Float64                             LinErrCorrectionFactor;

   UInt8 lambda_monitored_quality;
   UInt8 fringe_count_error_excessive; 
   UInt8 fringe_count_error_detected;
   Float32 ictTemperatureStability;
   Float32 ictTemperatureConsistency;

} ScienceDataRecordStatus;
#endif //_INC_SDRStatusRecord_INCLUDED
