/* BEGIN JPSS HEADER */
/*****************************************************************************
*
* Peraton, Inc.  All rights reserved.
*
* GOVERNMENT RIGHTS:
* Per contract 1332KP23CNEEJ0001, CAR 1352.227-70 applies giving full
* copyrights to data, including reports and other copyrighted materials
* to the United States Government.
*
* THIRD PARTY RIGHTS:
* Note: Third party entities may own copyrights in this work.
*
* EXPORT CONTROL:
* Unless otherwise specified beneath this header, this item does not contain
* Technology or Technical Data controlled under either the U.S. International
* Traffic in Arms Regulations or the U.S. Export Administration Regulations.
*
* CLASSIFICATION: B
* Refer to Software Standards and Practices Manual (SSPM) for coding and
* documentation standards.
*
*****************************************************************************/
/* END JPSS HEADER */

/*****************************************************************************
*
*  NAME: ProSdrCrisGbl.h
*
*  DESCRIPTION:  Contains structures that are global to CrIS SDR algorithm.
*
*****************************************************************************/

/***********************************************************************
*  HISTORY:
*  
* DATE        PR#      AUTHOR            Build    DESCRIPTION
* ---------   ---      ------            -----    -----------
* 04May2005            B. Henderson      1.3      Initial Version
* 03Apr2007 PCR013709  S. Antonom        1.5      Change the CRIMMS-ATMS-CRIS
*                                                 Granule to 32 sec.
* 13JUN2007            Stuhmer           1.5      Updated for Geo Anomaly quality
*                                                 flag.   Updated headers.
* 19Jun2007            Jeff DeLotelle    1.5      Updated copyright and government
*                                                 rights info in prologue.
* 27Jun2007            Jeff DeLotelle    1.5      Changed DS_Symmetry to DeepSpace_Symmetry
*                                                 for clarity.
* 29Jun2007            Dan Elliott       1.5      Modification based upon TM:
*                      Bryan Henderson             NP-EMD-2007.510.0027.Rev.A 
* 30Oct2007 PCR015919  Roger Ferrel      1.5x1    ECR-122 added spacecraft data to Geolocation.
* 14Dec2007 PCR015906  Kelly Boswell     1.5x1    ECR A-103, EDRPR 1.8 CP3 Updates
*                                                  CDFCB compliance updates: removed
*                                                  roll, pitch and yaw and swapped the
*                                                  ev and fov dimensions, and moved data
*                                                  members into their proper order in the geo
*                                                  structure
* 07Jan2008   15748    Bryan Henderson   1.5.x.1  ISTN_CRIS_SDR_NGST_1.1
*                                                 drop implementation
* 21Feb2008   15748    Kelly Boswell     1.5.x.1  ISTN_CRIS_SDR_NGST_1.1 drop 
*                                                 implementation - 
*                                                 implemented format updates
*                                                 for CDFCB-X compliance
*                                                 ref. NP-EMD-2007.510.0027
*                                                 RevB
* 24Apr2008   17500    Kelly Boswell     1.5.x.1  Created CrisSdrExitAngIPType.  
* 30Jun2008   17910    Kelly Boswell     1.5.x.1  Created CrisSdrRgeoTcType.
* 10JUN2009  020369    R. Ferrel         SensChar Created CrisSdrExitVectorType
* 07MAR2012   29676    T. Gardner        Mx7A     Corrected CRIS_RDR_INVALID_DATA_MASK 
*                                                 bit mask
* 31JUL2012   31562    T. Gardner        Mx6.3    Added IMAG_RAD_INVALID const
* 07AUG2013   35180    T. Gardner        Mx8.1    Added SDR_QUALITY_NA
* 25JUN2014            Y. Chen/Y.Han     Mx8.5    Modification of dimension normal 
*                                                 and full resolution 
* 14OCT2014  042555    SEClark        Blk2.0.0.4  CrIS SSPM Compliance.
* 03JAN2015   41268    J. Eberle         Blk2.0   Header Changes
* 11MAY2015   48586    T. Gardner        Blk2.0   Integrate TR/FR updates into
*                                                 block 2.0
* 24JUL2017            H. Xu/Y. Chen     Blk2.0   Added quality flag for spike correction
* 26APR2018   65628    G. Pachl          Blk2.1   Merged into Baseline CCR 3542.
***********************************************************************/

#ifndef ProSdrCrisGbl_H_
#define ProSdrCrisGbl_H_

#include <Typedefs.h>
#include <ProCmnPhysConst.h>
#include <ProCmnMathConsts.h>
#include <AutoGeneratedCrisProductsGbl.h>

/* Dimension and variable used in videodata */
const Int32 TOTAL_DETECTORS = 9;
const Int32 TOTAL_WAVELENGTHS = 3;
#ifdef FULL_RES
/* used in videodata */
const Int32 EXTRA_SAMPLES =(LW_FR_POINTS_DECIMATED_INTERFEROGRAM > 864) ? 0 : 1;
const Int32 MAX_SAMPLES = MW_FR_POINTS_DECIMATED_INTERFEROGRAM+2*EXTRA_SAMPLES;

/* Deimension used in CalibratedSpectra.cpp */
const Int32 MAX_POINTS_DECIMATED_INTERFEROGRAM = 
   MW_FR_POINTS_DECIMATED_INTERFEROGRAM;

// Hard-code the old values from the removed CrIS-Correct-Matrix-AUX.xml non-MUP file.
const Int32 LW_POINTS_DECIMATED_INTERFEROGRAM = 864;
const Int32 MW_POINTS_DECIMATED_INTERFEROGRAM = 528;
const Int32 SW_POINTS_DECIMATED_INTERFEROGRAM = 200;

const Int32 MW_NUMBER_OF_POINTS = MWFRNUMBEROFPOINTS;
const Int32 SW_NUMBER_OF_POINTS = SWFRNUMBEROFPOINTS;
const Int32 LW_POINTS_DECIMATED_IFGM = LW_FR_POINTS_DECIMATED_INTERFEROGRAM;
const Int32 MW_POINTS_DECIMATED_IFGM = MW_FR_POINTS_DECIMATED_INTERFEROGRAM;
const Int32 SW_POINTS_DECIMATED_IFGM = SW_FR_POINTS_DECIMATED_INTERFEROGRAM;

#else
///* used in videodata */
//const Int32 EXTRA_SAMPLES =(LW_POINTS_DECIMATED_INTERFEROGRAM > 864) ? 0 : 1;
//const Int32 MAX_SAMPLES = LW_POINTS_DECIMATED_INTERFEROGRAM+2*EXTRA_SAMPLES;
//
///* Deimension used in CalibratedSpectra.cpp */
//const Int32 MAX_POINTS_DECIMATED_INTERFEROGRAM = 
//   LW_POINTS_DECIMATED_INTERFEROGRAM;
//
//const Int32 MW_NUMBER_OF_POINTS = MWNUMBEROFPOINTS;
//const Int32 SW_NUMBER_OF_POINTS = SWNUMBEROFPOINTS;
//const Int32 LW_POINTS_DECIMATED_IFGM = LW_POINTS_DECIMATED_INTERFEROGRAM;
//const Int32 MW_POINTS_DECIMATED_IFGM = MW_POINTS_DECIMATED_INTERFEROGRAM;
//const Int32 SW_POINTS_DECIMATED_IFGM = SW_POINTS_DECIMATED_INTERFEROGRAM;
#endif

const Int32 MAX_TRIM_ELEMENTS = 16;
const Int32 FIR_PIPELINE_SAMPLES = 254;
const Int32 LW_DECIMATION_RATES  = 24;
const Int32 MW_DECIMATION_RATES  = 20;
const Int32 SW_DECIMATION_RATES  = 26;
const Int32 LW_COLLECTED_SAMPLES = LW_DECIMATION_RATES * 
   (LW_POINTS_DECIMATED_IFGM +2*EXTRA_SAMPLES) + FIR_PIPELINE_SAMPLES; 
const Int32 MW_COLLECTED_SAMPLES = MW_DECIMATION_RATES * 
   (MW_POINTS_DECIMATED_IFGM +2*EXTRA_SAMPLES) + FIR_PIPELINE_SAMPLES; 
const Int32 SW_COLLECTED_SAMPLES = SW_DECIMATION_RATES * 
   (SW_POINTS_DECIMATED_IFGM +2*EXTRA_SAMPLES) + FIR_PIPELINE_SAMPLES; 

/* Dimension used in DiagnosticData.cpp.cpp */
const Int32 MAX_DIA_SAMPLES = 21295;

/**
 * Number of bands for wave lengths.
 */
enum BandIndices
{
   /** Number of longwave bands. */
   LW = LW_POINTS_DECIMATED_IFGM,  

   /** Number of midwave bands. */
   MW = MW_POINTS_DECIMATED_IFGM,

   /** Number of shortwave bands. */
   SW = SW_POINTS_DECIMATED_IFGM
};

/* Different Calibration Approach */
enum CalibrationOrder
   {
      RadCalFirst_ATBD_versionA = 0,
      RadCalFirst_INVsaFPf_bigN,
      SpecCalFirst_FPfINVsaPf_dFIR_bigN_JP,
      RadCalFirst_FPfINVsaPf_bigN,      
   /** Number of Calibration Types. */
      TOTAL_ORDERS
   }; 
 
// Defines preserved from the deprecated IngMsdCoefficients_CrisSdrStruct.

/**
 * Indicates the Origin of the DS Temperature.
 */
enum DsTemperatureOriginSource
{
   DS_CCS = 0,
   DS_CONFIG,
   DS_CTC,

   /** Number of sources. */
   MAX_DSSOURCE
};

/**
 * Indicater of which type of Apodiztion is being used.
 */
enum ApodizationType
{
   BLACKMAN_HARRIS = 0,
   HAMMING,
   NONE,

   /** Number of Apodization Types. */
   MAX_APODIZATION_TYPE
};

/**
 * Where the instrument is located.
 */
enum InstrumentLocation
{
   BENCH = 0,
   CHAMBER
};

/**
 * Source of ICT Emissiity values.
 */
enum IctEmissivityOriginSource
{
   ICT_CONFIG = 0,
   ICT_TLM,

   /** Number of ICT Emissivitye sources. */
   MAX_ICTSOURCE
};

/**
 * Source of the Laser Wave values.
 */
enum LaserWavelengthSource
{
   LASER_CONFIG = 0,
   LASER_TLM,

   /** Number of laser sources. */
   MAX_LASER_SOURCES
};

/**
 * Source of Instrument Temperature values.
 */
enum InstrumentTemperatureOriginSource
{
   INSTRUMENT_CONFIG = 0,
   INSTRUMENT_TLM,

   /** Number of Instrument temperature sources. */
   MAX_INSTRUMENTSOURCE
};

/**
 * Source of Linearity Correction Control values.
 */
enum LinearityCorrectionControlOriginSource
{
    LINEARITY_CONFIG = 0,
    LINEARITY_TLM,
    MAX_LINEARITY_SOURCE
};

/**
 * Type of Spectral Calibration.
 */
enum SpectralCalibrationMethod
{
   CalibrationType_None = 0,
   CalibrationType_Complex,
   CalibrationType_Simple      
};

/**
 * How to organize the output.
 */
enum OutputStyle
{
   Mimic_Input_Style = 0,
   Organize_By_Metadata,
   NO_EXPORT
};

/**
 * Which scene element to use.
 */
enum SceneElement 
{
   FOV1 = 0,
   FOV2,
   FOV3,
   FOV4,
   FOV5,
   FOV6,
   FOV7,
   FOV8,
   FOV9,

   /** Number of Scene elements. */
   MAX_FOV
}; 

/**
 * Wave length band.
 */
enum Wavelength
{
   LONGWAVE = 0,
   MIDWAVE,
   SHORTWAVE,

   /** Number of wave lengths types. */
   TOTAL_BANDS
};

/**
 * The field of regard in use.
 */
enum FieldOfRegard 
{
   InternalCalTarget = 0,
   EarthScene1,
   EarthScene2,
   EarthScene3,
   EarthScene4,
   EarthScene5,
   EarthScene6,
   EarthScene7,
   EarthScene8,
   EarthScene9,
   EarthScene10,
   EarthScene11,
   EarthScene12,
   EarthScene13,
   EarthScene14,
   EarthScene15,
   EarthScene16,
   EarthScene17,
   EarthScene18,
   EarthScene19,
   EarthScene20,
   EarthScene21,
   EarthScene22,
   EarthScene23,
   EarthScene24,
   EarthScene25,
   EarthScene26,
   EarthScene27,
   EarthScene28,
   EarthScene29,
   EarthScene30,
   DeepSpace,
   NonStandardDwell,
   Nadir,
   /** Number of fields of reguard. */
   ING_TOTAL_SCENES
};


/**
 * Dimension for various label arrays.
 */
enum labelSizes
{
   /** The forward Sweep Dirction Label size. */
   LB_FWD_SW_DIR = 2,

   /** The LW Band Label size. */
   LB_LW_BAND = 3,

   /** The MW Band Label size. */
   LB_MW_BAND = 3,

   /** The Reverse Sweep dirction Label size. */
   LB_REV_SW_DIR = 2,

   /** The SW Band Label size. */
   LB_SW_BAND = 3,

   /** The rotation matrix vector size. */
   LB_VEC_SIZE = 3
};

/**
 * Dimension indeces for surface emmissivity coefficients.
 */
enum SurfaceEmissivityCoeffIdxEnum
{
    SURF_EMISS_COEFF_C0 = 0,
    SURF_EMISS_COEFF_C1,
    SURF_EMISS_COEFF_C2,
    SURF_EMISS_COEFF_C3
};
// End defines preserved from IngMsdCoefficients_CrisSdrStruct.

// const UInt32 CRIS_SCAN_PER_GRAN = 4;   // number of scans per granule
const UInt8 QF_PADDING_SIZE = CRIS_SCAN_PER_GRAN % 2;
// Total FOR per scan, earth, deep space and internal calibration
const UInt32 TT_FOR_PER_SCAN = EV_FOR_PER_SCAN+DS_FOR_PER_SCAN+IC_FOR_PER_SCAN;
const UInt32 CRIS_STRING_SIZE = 8;     // maximum length of header strings

// CrIS sliding window size
const unsigned int CRIS_WINDOW_SIZE = 30;

// Define the min/max values for the radiance values
const Int16 LW_MAX_RADIANCE = 300;
const Int16 MW_MAX_RADIANCE = 200;
const Int16 SW_MAX_RADIANCE = 20;
const Int16 LW_MIN_RADIANCE = -300;
const Int16 MW_MIN_RADIANCE = -200;
const Int16 SW_MIN_RADIANCE = -20;

// Number of bits per byte.
const Int32 NBITS_PER_BYTE = 8;

// Byte offset for FOR in packet
const UInt32 FOR_OFFSET = 0x10;
// Mask for FOR 
const UInt8 FOR_MASK = 0xfc;
// Shift for FOR 
const UInt8 FOR_SHIFT = 2;
// Mask for Direction
const UInt8 DIRECTION_MASK = 0x3;

const UInt32 MAX_NUMBER_SCIENCE_APIDS = 83;

// Structure contains the CrIS SDR header information
typedef struct CrisSdrHdrDataType
{
    CrisSdrHdrDataType()
    :granuleBeginTime(0), granuleEndTime(0), firstScanTime(0),
     lastScanTime(0), flightSoftwareVersion(0){}

    // Begin boundry time of the granule, in IET format
    UInt64 granuleBeginTime;
    // End boundry time of the granule, in IET format
    UInt64 granuleEndTime;
    // Time of the first scan in the granule, in IET format
    UInt64 firstScanTime;
    // Time of the last scan in the granule, in IET format
    UInt64 lastScanTime;
    // ATMS flight software version
    Int32 flightSoftwareVersion;
    // Software Version
    Int8 softwareVersion[CRIS_STRING_SIZE];
    // ATMS sensor ID
    Int8 sensorID[CRIS_STRING_SIZE];
    // Spacecraft ID
    Int8 spacecraftID[CRIS_STRING_SIZE];
} CrisSdrHdrDataType;

const UInt8 DATA_GAP = 0x01;
const UInt8 TIMING_SEQUENCE_ERROR = 0x02;
const UInt8 LAMBDA_MONITORED_QUALITY = 0x04; // will be implemented by DPSE
const UInt8 INVALID_INSTRUMENT_TEMPERATURES = 0x08; // will be implemented by DPSE
const UInt8 EXCESS_THERMAL_DRIFT = 0x10;
const UInt8 SUSPECT_NEON_CALIBRATION = 0x20;
const UInt8 SPARE_SCAN = 0xc0;

const UInt8 LUNAR_INTRUSION_FWD = 0x01;
const UInt8 LUNAR_INTRUSION_REV = 0x02;
const UInt8 SPARE_FOV = 0xfc; 

const UInt32 CRIS_SDR_INVALID_DATA_MASK = 0x2;
const UInt32 SDR_QUALITY_GOOD = 0;
const UInt32 SDR_QUALITY_DEGRADED = 1;
const UInt32 SDR_QUALITY_INVALID = 2;
const UInt8 SDR_QUALITY_NA = 3; // Set SDR Quality to 3 = fake data for short granule

const UInt8 SDR_QUALITY = 0x03; // 3=NA 2=invalid, 1=degraded, 0=good 
const UInt8 INVALID_GEOLOCATION = 0x04; // 0=valid
// 2=invalid, 1=degraded, 0=good
const UInt8 GOOD_RADIOMETRIC_CALIBRATION = 0x0;
const UInt8 DEGRADED_RADIOMETRIC_CALIBRATION = 0x8;
const UInt8 INVALID_RADIOMETRIC_CALIBRATION = 0x10; 
// 2=invalid, 1=degraded, 0=good
const UInt8 GOOD_SPECTRAL_CALIBRATION = 0x0;
const UInt8 DEGRADED_SPECTRAL_CALIBRATION = 0x20;
const UInt8 INVALID_SPECTRAL_CALIBRATION = 0x40; 
const UInt8 FRINGE_COUNT_ERROR_CORRECT_FAIL = 0x80;


const Float32 CrIS_SZA_NIGHTYNIGHT_THRESHOLD = 90.0*DEG2RAD;
const UInt32 CRIS_RDR_INVALID_DATA_MASK = 0xe;

const UInt8 DAYNIGHT_INDICATOR = 0x01; // 0=day,1=night(SZA>90)
const UInt8 INVALID_RDR_DATA = 0x02;
const UInt8 FRINGE_COUNT_ERROR_DETECTED = 0x04;
const UInt8 BIT_TRIM_FAILED = 0x08;
const UInt8 IMAG_RAD_INVALID = 0x10;
const UInt8 SPARE_BAND = 0xF0;

//CrIS spike correction status  
enum SpikeCorrectionStatus
{
	NO_SPIKE = 0,
	SPIKE_DETECTED,
	SPIKE_CORRECTED
};
/*
ES spike correction status are recorded in QF4 dataset
QF4:
     _________________________________
     |_7_|_6_|_5_|_4_|_3_|_2_|_1_|_0_|
bits 5-6: used for ES spike correction

the (2)bits of ES are used to record totally 3 of its spike correction status,
    00: no spike
    01: spike corrected
    10: spike detected but correction failed
*/
// (ES)
const UInt8 ES_SPIKE_CORRECTED = 0x20;         // 32   spike corrected
const UInt8 ES_SPIKE_DETECTED  = 0x40;         // 64   spike detected but correction failed

/*
ICT and DS spike correction status are recorded in QF2 dataset
QF2:
     _________________________________
     |_7_|_6_|_5_|_4_|_3_|_2_|_1_|_0_|
bits 2-4: used for ICT spike correction
bits 5-7: used for DS  spike correction

the (3)bits of ICT and DS are used to record totally 8 of their own spike correction status, 
    category 1: 
        000: no spike
	category 2: (1 spike)
        001: spike corrected in forward swpeep
        010: spike detected in forward swpeep direction but correction failed
        101: spike corrected in reverse swpeep
        110: spike detected in reverse swpeep direction but correction failed
	category 3: (2 spikes)
        011: spikes are corrected in both sweep direction
        100: spikes are successfully corrected in one sweep direction but failed in another direction
        111: spikes are detected but correction failed in both sweep direction
*/
// (ICT) 
const UInt8 ICT_DEFAULT_SPIKE_STATUS = 0xE3;    // 227 used to set the ICT spike status as default 0
const UInt8 ICT_SPIKE_STATUS = 0x1C;            // 28  used to get ICT spike status (sweep direction + correction status)
const UInt8 ICT_SPIKE_CORRECTION_STATUS = 0x0C; // 12  used to get ICT spike correction status (only the correction status)
// following variables are used to record ict spike correction status:
const UInt8 ICT_SPIKE_CORRECTED = 0x04;         // 4   spike corrected
const UInt8 ICT_SPIKE_DETECTED = 0x08;          // 8   spike detected but correction failed 
const UInt8 ICT_SPIKE_IN_REVERSE = 0x10;        // 16  spike detected in reverse sweep direction
const UInt8 ICT_SPIKE_BOTH_CORRECTED = 0x0C;    // 12  spikes are corrected in both sweep direction
const UInt8 ICT_SPIKE_ONE_DETECTED_ONE_CORRECTED = 0x10; // 16 spikes are successfully corrected in one sweep direction but failed in another direction
const UInt8 ICT_SPIKE_BOTH_DETECTED = 0x1C;     // 28  spikes are detected but correction failed in both sweep direction

// (DS)
const UInt8 DS_DEFAULT_SPIKE_STATUS = 0x1F;    // 31  used to set the DS spike status as default 0
const UInt8 DS_SPIKE_STATUS = 0xE0;            // 224 used to get DS spike status (sweep direction + correction status)
const UInt8 DS_SPIKE_CORRECTION_STATUS = 0x60; // 96  used to get DS spike correction status (only the correction status)
// following variables are used to record ds spike correction status:
const UInt8 DS_SPIKE_CORRECTED = 0x20;         // 32  spike corrected
const UInt8 DS_SPIKE_DETECTED  = 0x40;         // 64  spike detected but correction failed
const UInt8 DS_SPIKE_IN_REVERSE= 0x80;         // 128 spike detected in reverse sweep direction
const UInt8 DS_SPIKE_BOTH_CORRECTED = 0x60;    // 96 spikes are corrected in both sweep direction
const UInt8 DS_SPIKE_ONE_DETECTED_ONE_CORRECTED = 0x80; // 128 spikes are successfully corrected in one sweep direction but failed in another direction
const UInt8 DS_SPIKE_BOTH_DETECTED = 0xE0;     // 224  spikes are detected but correction failed in both sweep direction

// The struct contains the exit angles of the spacecraft.
typedef struct {
    Float32 roll[CRIS_SCAN_PER_GRAN][EV_FOR_PER_SCAN][CRIS_MAX_FOV];
    Float32 pitch[CRIS_SCAN_PER_GRAN][EV_FOR_PER_SCAN][CRIS_MAX_FOV];
} CrisSdrExitAngIPType;

// The terrain-corrected geo product.  Currently, it's a combination of
// the CrisSdrGeolocationType and the CrisSdrExitAngIPType in order to
// combine two output products into one.
typedef struct {
    CrisSdrExitAngIPType angData;
    CrisSdrGeolocationType geoData;
} CrisSdrRgeoTcType;

#endif // ProSdrCrisGbl_H_
