/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.ncdc.borg5;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.regex.Pattern;

public class createChecksum {
    static String FS = File.separator;

    public static class MD5Checksum {
        public static byte[] createChecksum(String filename) throws Exception {
            int numRead;
            FileInputStream fis = new FileInputStream(filename);
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            return complete.digest();
        }

        public static String getFileSize(String ifile) {
            File f = new File(ifile);
            long l = f.length();
            String fs = Long.toString(l);
            return fs;
        }

        public static String getMD5Checksum(String filename) throws Exception {
            byte[] b = MD5Checksum.createChecksum(filename);
            String result = "";
            int i = 0;
            while (i < b.length) {
                result = String.valueOf(result) + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
                ++i;
            }
            return result;
        }

        public static void main(String[] args) {
            String fn = args[0];
            String regularExpression = "([\\w\\\\w ./-]+\\w+(\\.)?\\w+)";
            Pattern pattern = Pattern.compile("([\\w\\\\w ./-]+\\w+(\\.)?\\w+)");
            boolean isMatched = pattern.matcher(fn).matches();
            try {
                String mfFile = String.valueOf(fn) + ".mnf";
                int ill = fn.lastIndexOf(FS);
                String fnS = fn.substring(ill + 1);
                FileWriter out = new FileWriter(mfFile);
                BufferedWriter o_file = new BufferedWriter(out);
                try {
                    String cksum = MD5Checksum.getMD5Checksum(fn);
                    String fsize = MD5Checksum.getFileSize(fn);
                    o_file.write(String.valueOf(fnS) + "," + cksum + "," + fsize);
                    o_file.newLine();
                    o_file.close();
                    System.out.println(String.valueOf(fn) + " cksum=" + cksum);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(0);
                }
                File f = new File(fn);
                long l = f.length();
                String string = Long.toString(l);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

