#!/bin/bash

# generate-mnf.sh
#=====================================================================
#  DATE: 2017-03-10
#  AUTHOR: Philip Jones, Contractor, at NOAA/NESDIS/NCEI
#  PURPOSE: generate companion submission manifest file(s)
#  EXAMPLE: run script on all *.tar files in current directory
#  ./generate-mnf.sh *.tar
#=====================================================================

# Specify output directory for submission manifest file(s)

outputdir=$(pwd)'/'
outputcount=0

# Generate a submission manifest file for each input file

if [[ -n "$1" ]]; then

    inputfiles="$@"
    inputcount=$(find $inputfiles -type f | wc -l)

    for file in $inputfiles; do
        if [[ -e $file ]]; then
            filename="${file##*/}"
            filehash=($(md5sum "$filename"))
            filesize=$(wc -c <"$filename")
            printf "$filename,$filehash,$filesize" > "$outputdir$filename.mnf"
			outputcount=$(( $outputcount + 1 ))
        else
            printf "No such file or directory: $file\n"
        fi
    done

else
    printf "Warning: script requires input file(s) as command line argument\n"
	exit 0
fi

# Print output
    printf "Output file directry: $outputdir\n"
    printf "Output file count: $outputcount\n"

exit 0
