.TH PSTEXT l DATE VERSION VERSION
.SH NAME
pstext \- To plot text on maps
.SH SYNOPSIS
\fBpstext\fP \fItextfile\fP \fB\-J\fP\fIparameters\fP 
\fB\-R\fIwest/east/south/north\fP[\fBr\fP] 
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-C\fP\fIdx/dy\fP ]  
\fB\-D\fP[\fBj\fP]\fIdx/dy\fP[\fBv\fP[\fIred/green/blue\fP] ] [ \fB\-E\fP\fIazimuth/elevation\fP ] 
[ \fB\-G\fP\fIred/green/blue\fP ] [ \fB\-H\fP[\fInrec\fP] ] [ \fB\-K\fP ] [ \fB\-L\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] 
[ \fB\-S\fP\fIpen\fP ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-W\fP[\fIred/green/blue\fP][\fBo|O|c|C\fP[\fIpen\fP]] ] 
[ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-Z\fP\fIzlevel\fP ] 
[ \fB\-c\fP\fIcopies\fP ] [ \fB\-:\fP ]
.SH DESCRIPTION
\fBpstext\fP plots textstrings of variable size, font type, and orientation.
Various map projections are provided, with the option to draw and annotate the
map boundaries. \fIPostScript\fP code is written to standard output.  Greek
characters, subscript, superscript, and small caps are supported as follows:
The sequence @~ toggles between the selected font and Greek (Symbol).
@%\fIno\fP% sets the font to \fIno\fP; @%% resets the font to the starting font,
@- toggles subscripts on/off, @+ toggles superscript on/off, and @# toggles small
caps on/off.  @@ prints the @ sign.  @e, @o, @a, @E, @O, @A give the accented
Scandinavian characters.  Composite characters (overstrike) may be indicated with
the @!<char1><char2> sequence, which will print the two characters on top of
each other.  To learn the octal codes for symbols not available on the keyboard
and some accented European characters, see Section 4.16 and Appendix F in the
\fBGMT\fP Technical Reference and Cookbook.  Note that WANT_EURO_FONT must be
set to TRUE in your .gmtdefaults file in order to use the accented characters.
Using the \fB\-W\fP option, a colored rectangle underlying the text may
be plotted  (Does not work for strings with sub/super scripts, symbols, or composite
characters, except in paragraph mode (\fB\-M\fP)).
.TP
\fItextfile\fP
This file contains 1 or more records with (\fIx, y, size, angle, fontno, justify, text\fP).
If no file is given, \fBpstext\fP will read standard input.
\fIsize\fP is text size in points, \fIangle\fP is measured in degrees counter-clockwise from horizontal, 
\fIfontno\fP sets the font type, \fIjustify\fP sets the alignment. 
If \fIfontno\fP is not an integer, then it is taken to be a textstring with the desired fontname.  See the \fBgmtdefaults\fP man page
for names and numbers of avaiable fonts (or run \fBpstext \-L\fP).  The alignment refers to the
part of the textstring that will be mapped onto the (\fIx,y\fP) point.  Choose a 2 character combination
of L, C, R (for left, center, or right) and T, M, B for top, middle, or bottom. e.g., BL for lower left.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-Jz
Sets the vertical scaling (for 3-D maps).  Same syntax as \fB\-Jx\fP.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals; see the
\fBpsbasemap\fP man page for details.
.TP
.B \-C
Sets the clearance between the text and the surrounding box [0.15\fBc\fP/0.15\fBc\fP (or 0.05\fBi\fP/0.05\fBi\fP)].
Only used if \fB\-W\fP is specified.
.TP
.B \-D
Offsets the text from the projected (\fIx,y\fP) point by \fIdx,dy\fP [0/0].
Use \fB-Dj\fP to offset the text away from the point instead (i.e. the text's justification
will determine the direction of the shift).  In paragraph mode
(\fB\-M\fP), one may append \fBv\fP which will draw a line from the original point to the shifted point.
Optionally append a \fIpen\fP for this line.
.TP
.B \-E
Sets the viewpoint's azimuth and elevation (for perspective view) [180/90].
(Not implemented for paragraph mode).
.TP
.B \-G
Sets the gray-shade (0-255) or color (r/g/b, each 0-255) used for drawing the text.  [Default is black]
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults file.  If used, \fBGMT\fP default is 1 header record.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-L
Lists the font-numbers and font-names available, then exits.
.TP
.B \-M
Paragraph mode.  Files must be multiple segment files.  Segments are separated by
a special record whose first character must be \fIflag\fP [Default is '>'].
Starting in the 3rd column, we expect to find information pertaining to the
typesetting of a text paragraph (the remaining lines until next segment header).
The information expected is (x y size angle fontno justify linespace parwidth parjust),
where \fIx y size angle fontno justify\fP are defined above, while \fIlinespace\fP
and \fIparwidth\fP are the linespacing and paragraph width, respectively.  The justification
of the text paragraph is governed by \fIparjust\fP which may be \fBl\fP(eft), \fBc\fP(enter),
\fBr\fP(ight), or \fBj\fP(ustified).  The segment header is followed by one or more lines
with paragraph text.  Text may contain the escape sequences discussed above as well as three
more: @;\fIr/g/b\fP; changes the font color (@;; resets it), @:\fIsize\fP: changes the
font size (@:: resets it), and @_ toggles underline on/off.  Separate paragraphs with a blank line.
.TP
.B \-N
Do NOT clip text at map boundaries [Default will clip].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-S
Draw text outline. Append pen attributes.
(Not implemented for paragraph mode).
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The GMT parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Paint a rectangle beneath the text string.  Set color [Default is no fill].
Append \fBo\fP to draw rectangle outline, add a \fIpen\fP to specify pen attributes [1/0/0/0].
Choose upper case \fBO\fP to get a rounded rectangle (only in paragraph mode).
Choose lower case \fBc\fP to get a concave rectangle (only in paragraph mode).
Choose upper case \fBC\fP to get a convex rectangle (only in paragraph mode).
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
.B \-Z
For 3-D projections:  Sets the z-level of the basemap [0].
(Not implemented for paragraph mode).
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input/output.  [Default is (longitude,latitude)].
Applies to geographic coordinates only.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To plot the outlines of the textstrings stored in the file text.d on a Mercator plot with
the given specifications, try
.br
.sp
pstext text.d \fB\-R\fP-30/30/-10/20 \fB\-Jm\fP0.1\fBi\fP \fB\-P \-B\fP5 \fB\-S\fP0.5\fBp\fP > plot.ps
.br
.sp
To add a typeset figure caption for a 3-inch wide illustration, try
.br
.sp
pstext \fB\-R\fP0/3/0/5 \fB\-JX\fP3\fBi\fP \fB\-O \-H \-M \-N\fP << EOF >> figure.ps
.br
This is an optional header record
.br
> 0 -0.5 12 0 4 LT 13p 3i j
.br
@%5%Figure 1.@%%  This illustration shows nothing useful, but it still needs
.br
a figure caption.  Highlighted in @;255/0/0;red@;; you can see the locations
.br
of cities where it is @_impossible@_ to get any good Thai food; these are to
be avoided.
.br
EOF
.br
.SH BUGS
Except for paragraph mode, the horizontal justification of surrounding rectangles
does not work when Greek symbols, sub- and superscripts, and/or composite characters
are imbedded in the textstring.  In paragraph mode, the presence of composite
characters and other escape sequences may lead to unfortunate word splitting. 
Finally, the outline option does not work with the escape sequences.
.br
The \fB\-N\fP option does not adjust the BoundingBox information so you may
have to post-process the PostScript outout with epstool or ps2epsi to obtain
a correct BoundingBox.
.SH "SEE ALSO"
.IR gmt (l),
.IR psbasemap (l)
