.TH GMTTRACK GMTMANSECTION DATE VERSION VERSION
.SH NAME
gmttrack \- A shiptrack plotting program
.SH SYNOPSIS
\fBgmttrack\fP \fIleg-ids\fP \fB\-R\fIwest/east/south/north\fP \fB\-J\fP\fIparameters\fP 
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-M\fP\fItrackticks\fP ] [ \fB\-W\fP\fIpen\fP[\fIred/green/blue\fP][\fBOA\fP] ] 
[ \fB\-A\fP[\fIsize\fP] ] 
[ \fB\-P\fP ] [ \fB\-O\fP ] [ \fB\-K\fP ]  [ \fB\-U\fP[\fIdx/dy/\fP][\fIlabel\fP] ] [ \fB\-X\fP\fIx-shift\fP ] 
[ \fB\-Y\fP\fIy-shift\fP ] [ \fB\-c\fP\fIcopies\fP ] [ \fB\-V \fP ]
.SH DESCRIPTION
gmttrack reads gmt cruises and creates PostScript code that will plot one or more ship tracks on a
map using the specified projection.  The PostScript code is written to standard output.
.TP
\fIleg-ids\fP
Can be one or more gmtleg-names, like c2104 v3206 etc.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals; see the
\fBpsbasemap\fP man page for details.
.TP
.B \-A
Annotate each leg every time it enters the plot. Optional \fIsize\fP is character size in points.
.TP
.B \-Da
Do not plot data collected before \fIstartdate\fP (mm/dd/yyyy/hh:mm)  [Default is first day].
.TP
.B \-Db
Do not plot data collected after \fIstopdate\fP (mm/dd/yyyy/hh:mm). [Default is last day].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
To put time/distance Marks on the track. E.g. \fBa\fP500\fBka\fP24\fBht\fP6\fBh\fP means (\fBa\fP)nnotate
every 500 km (\fBk\fP) and 24 \fBh\fP(ours), with (\fBt\fP)ickmarks every 500 km and 6 hours.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-Sa
Do not plot data that are less than \fIstartdist\fP km along track from port of departure. [Default is 0].
.TP
.B \-Sb
Do not plot data that are more than \fIstopdist\fP km along track from port of departure. [Default is length of track].
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The GMT parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-W
\fIpen\fP is thickness of the trackline. [Default is 1].  Optionally, specify the rgb combination
to obtain a colored trackline [Default is black]. Append O for dOtted line, a for dAshed. 
[Default is solid]
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To generate a Mercator plot of the track of cruises C2610 and V1512 in the area 150E to
154E, 18N to 23N, using a Mercator scale of 1.5inch/degree, label the tracks with 10 points characters, annotate
the boundaries every degree, and draw gridlines every 30 minutes, enter the following command:
.br
.sp
gmttrack c2610 v1512 \fB\-R\fP150/154/18/23 \fB\-Jm\fP1.5 \fB\-B\fP1\fBg\fP30\fBm \-A\fP10 | lpr
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR psbasemap (GMTMANSECTION)
.SH REFERENCES
Wessel, P., and W. H. F. Smith, 2004, The Generic Mapping Tools (GMT) version
3.4.5 Technical Reference & Cookbook, SOEST/NOAA.
.br
Wessel, P., and W. H. F. Smith, 1998, New, Improved Version of Generic Mapping
Tools Released, EOS Trans., AGU, 79 (47), p. 579.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, EOS Trans., AGU, 76 (33), p. 329.
.br
Wessel, P., and W. H. F. Smith, 1995, New Version of the Generic Mapping Tools
Released, http://www.agu.org/eos_elec/95154e.html, Copyright 1995 by the
American Geophysical Union.
.br
Wessel, P., and W. H. F. Smith, 1991, Free Software Helps Map and Display Data,
EOS Trans., AGU, 72 (41), p. 441.
.br
