.TH PSSEGYZ GMTMANSECTION DATE VERSION VERSION
.SH NAME
pssegyz \- Create imagemasked postscript from SEGY file
.SH SYNOPSIS
\fBpssegyz\fP \fISEGYfile\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest/east/south/north\fP \fB\-D\fP\fIdeviation 
\fB\-F\fP[\fBrgb|gray\fP]|-W 
[ \fB\-I\fP] [ \fB\-N\fP ] [ \fB\-B\fP\fIbias\fP ] [ \fB\-C\fP\fIclip\fP ] 
[ \fB\-Z\fP ] [ \fB\-X\fP\fIscale\fP ] [ \fB\-Y\fP\fIsample int\fP ]
[ \fB\-S\fP\fIheader_x\fP/\fIheader_y\fP ] [ \fB\-L\fP\fInsamp\fP ] 
[ \fB\-M\fP\fIntrace\fP ] [ \fB\-U\fP\fIredvel\fP ]
[ \fB-E\fP\fIazimuth\fP/\fIelevation\fP ]
[ \fB\-O\fP ] [ \fB\-K\fP ] [ \fB\-P\fP ][ \fB\-V \fP ] 
.SH DESCRIPTION
\fBpssegyz\fP reads a native (IEEE) format SEGY file and produces a
\fIPostScript\fP image of the seismic data. The \fIimagemask\fP
operator is used so that the seismic data are plotted as a 1-bit
deep bitmap in a single
(user-specified) color or gray shade, with a transparent background.
The bitmap resolution is taken from the current GMT defaults.
The seismic traces may be plotted at their true locations using information
in the trace headers (in which case order of the
traces in the file is not significant).
 Standard GMT geometry routines are used so that
in principle any map projection may be used, however it is likely that the
geographic projections will lead to unexpected results. Beware also
that some parameters have non-standard meanings, and a couple of
the options for \fBpssegy\fP are not available in \fBpssegyz\fP.
Note that the order of operations before the seismic data are plotted is
deviation*[clip]([bias]+[normalize](sample value)). Deviation determines
how far \fIin the plot coordinates\fP a [normalized][biased][clipped] sample
value of 1 plots from the trace location.
The SEGY file should be a disk image of the tape format (ie 3200 byte
text header, which is ignored, 400 byte binary reel header, and
240 byte header for each trace) with samples as native real*4 (IEEE real
on all the platforms to which I have access)
.TP
\fISEGYfile\fP
Seismic data set to be imaged
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest.  To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
.br
.TP
.B \-D
gives the deviation in X units of the plot for 1.0 on the scaled trace,
This may
be a single number (applied equally in X and Y directions) or devX/devY
.br 
.TP
.B \-F[\fIrgb\fP|\fIgray\fP]
Fill trace (variable area, defaults to filling positive). rgb or gray gives
the color with which the imagemask is filled.
.TP
.B \-W
Draw wiggle trace.
.TP
\fI Must specify at least one of -W and -F.\fP
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-I
Fill negative rather than positive excursions.
.TP
.B \-N
Normalize trace by dividing by rms amplitude over full trace length.
.TP
.B \-B
Bias to apply to data (added to sample values).
.TP
.B \-C
Sample value at which to clip data (clipping is applied to both positive and
negative values).
.TP
.B \-Z
Do not plot traces with zero rms amplitude.
.TP
.B \-X
Multiply trace locations by scale before plotting.
.TP
.B \-Y
Override sample interval in reel header.
.TP
.B \-S
Read trace locations from trace headers: header is either c for CDP,
o for offset, b<num> to read a long starting at byte <num> in the
header (first byte corresponds to num=0), or a number to fix the location.
 First parameter for x, second for y. Default has X and Y given by trace
number.
.TP
.B \-L
Override number of samples per trace in reel header (program attempts to
determine number of samples from each trace header if possible to
allow for variable length traces).
.TP
.B \-M
Override number of traces specified in reel header. Program detects
end of file (relatively) gracefully, but this parameter limits number
of traces that the program attempts to read.
.TP
.B \-U
Apply reduction velocity by shifting traces \fIupwards\fP by redvel/|offset|.
Negative velocity removes existing reduction. Units should be consistent with
offset in trace header and sample interval.
.TP
.B \-E
Azimuth and elevation for the 3-D projection.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.SH EXAMPLES
To plot the SEGY file wa1.segy with normalized traces plotted at true offset 
locations, clipped at +-3 and with wiggle trace and positive variable area
shading in black, try
.br
.sp
pssegyz wa1.segy \fB\-JX\fP5/\-5 \fB\-D\fP1 \fB\-Jz0.05\fP \fB\-E\fP180/5 \fB\-R\fP0/100/0/10/0/10 \fB\-C\fP3 \fB\-N\fP \fB\-S\fPo \fB\-W\fP \fB\-F\fP0 > segy.ps
.br
.SH BUGS
Variable area involves filling four-sided figures of distressing generality.
I \fIknow\fP that some of the more complex degenerate cases are not
dealt with correctly or at all; the incidence of such cases increases
as viewing angles become more oblique, and particularly as the
viewing elevation increases. Wiggle-trace plotting is not affected.
.SH "SEE ALSO"
.IR gmt (GMTMANSECTION),
.IR pssegy (GMTMANSECTION)
