.TH GRDIMAGE l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
grdimage \- Create grayshaded or colored image from a 2-D netCDF grd file
.SH SYNOPSIS
\fBgrdimage\fP \fIgrd_z\fP | \fIgrd_r grd_g grd_b\fP \fB\-C\fP\fIcptfile\fP \fB\-J\fP\fIparameters\fP 
[ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-Ei\fP|\fIdpi\fP ] [ \fB\-G\fP[\fBf|b\fP]\fIrgb\fP ] [ \fB\-I\fP\fIintensfile\fP] 
[ \fB\-K\fP ] [ \fB\-M\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-Q\fP ] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] 
[ \fB\-S\fP\fIsearch_radius\fP ] [ \fB\-T\fP[\fBs\fP][\fBo\fP[\fIpen\fP]] ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] [ \fB\-V\fP ] 
[ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBgrdimage\fP reads one 2-D gridded file and produces a gray-shaded (or colored) map by assigning
each z-value a gray-shade (or color). 
Alternatively, \fBgrdimage\fP reads three 2-D gridded files with the red, green, and blue components
directly (all must be in the 0-255 range). Optionally, illumination may be added by providing
a file with intensities in the (-1,+1) range.  Values outside this range will be clipped.
Such intensity files can be created from the
grdfile using \fBgrdgradient\fP and modified by \fBgrdmath\fP or \fBgrdhisteq\fP.  Each grid-node
in the grdfile is represented as a shaded (or colored) rectangle centered on the grid node.  When
using map projections, the grid is first resampled on a new rectangular grid  (This can be a
time-consuming process for large grid files; but see \fB\-T\fP).  A 24-bit true color \fIPostScript\fP
file is output.  The region option can be used to select a map region larger or smaller than that
implied by the extent of the grdfile.
.TP
\fIgrd_z\fP | \fIgrd_r grd_g grd_b\fP
2-D gridded data set (or red, green, blue grids) to be imaged
.TP
.B \-C
name of the color palette table (for \fIgrd_z\fP only).
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-E
Sets the resolution of the projected grid that will be created if
a map projection other than Linear or Mercator was selected.  By default,
the projected grid will be of the same size (rows and columns) as the
input file.  Specify \fBi\fP to use the \fIPostScript\fP
image operator to interpolate the image at the device resolution.
.TP
.B \-G
This option only applies when the resulting image otherwise would consist
of only two colors: black (0) and white (255).  If so, this option will
instead use the image as a transparent mask and paint the mask (or its
inverse, with \fB\-Gb\fP) with the given color combination.
.TP
.B \-I
Gives the name of a grdfile with intensities in the (-1,+1) range. [Default is no illumination].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Force conversion to monochrome image using the (television) YIQ transformation.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-Q
Mask out nodes with z = NaN using the colormasking feature in \fIPostScript\fP Level 3
(the PS device must support PS Level 3).
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
You may ask for a larger \fIw/e/s/n\fP region to have more room between the image and the axes.
A smaller region than specified in the grdfile will result in a subset of the grid [Default is
region given by the grdfile].
.TP
.B \-S
Set the search radius for the averaging procedure  [Default avoids aliasing].
.TP
.B \-T
Plot image without any interpolation.  This involves converting each node-centered
bin into a polygon which is then painted separately.  Append \fBs\fP to skip
nodes with z = NaN.  This option is useful for categorical data where
interpolating between values is meaningless.  Optionally, append \fBo\fP to
draw the tile outlines, and specify a custom pen if the default pen is not to
your liking.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.TP
.B \-f
Special formatting of input and output columns (time or geographical data).
Specify \fBi\fP(nput) or \fBo\fP(utput) [Default is both input and output].
Give one or more columns (or column ranges) separated by commas.
Append \fBT\fP (Absolute calendar time), \fBt\fP (time relative to chosen \fBTIME_EPOCH\fP),
\fBx\fP (longitude), \fBy\fP (latitude), or \fBf\fP (floating point) to each column
or column range item.  Shorthand \fB\-f\fP[\fBi\fP|\fBo\fP]\fBg\fP means \fB\-f\fP[\fBi\fP|\fBo\fP]0\fBx\fP,1\fBy\fP
(geographic coordinates).
.SH EXAMPLES
To gray-shade the file hawaii_grav.grd with shades given in shades.cpt on a Lambert map
at 1.5 cm/degree along the standard parallels 18 and 24, and using 1 degree tickmarks:
.br
.sp
\fBgrdimage\fP hawaii_grav.grd \fB\-Jl\fP18/24/1.5\fBc\fP \fB\-C\fPshades.cpt \fB\-B\fP1 > hawaii_grav_image.ps
.br
.sp
To create an illuminated color \fIPostScript\fP plot of the gridded data set image.grd, using the
intensities provided by the file intens.grd, and color
levels in the file colors.cpt, with linear scaling at 10 inch/x-unit, tickmarks every 5 units:
.br
.sp
\fBgrdimage\fP image.grd \fB\-Jx\fP10\fBi\fP \fB\-C\fPcolors.cpt \fB\-I\fPintens.grd \fB\-B\fP5 > image.ps
.br
.sp
To create an false color \fIPostScript\fP plot from the three gridded files red.grd, green.grd, and blue.grd,
with linear scaling at 10 inch/x-unit, tickmarks every 5 units:
.br
.sp
\fBgrdimage\fP red.grd green.grd blue.grd \fB\-Jx\fP10\fBi\fP \fB\-B\fP5 > rgbimage.ps
.SH "SEE ALSO"
.IR GMT (l),
.IR gmt2rgb (l),
.IR grdcontour (l),
.IR grdview (l),
.IR grdgradient (l),
.IR grdhisteq (l)
