.TH PS2RASTER l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
ps2raster \- Converts one or several \fIPostScript\fP file(s) to raster formats using GhostScript
.SH SYNOPSIS
\fBps2raster\fP \fIpsfile(s)\fP [ \fB\-A\fP ] [ \fB\-E\fP\fIresolution\fP ] [ \fB\-G\fP\fIghost_path\fP ] 
[ \fB\-L\fP\fIlistfile\fP]  [ \fB\-N\fP ] [ \fB\-Tf\fP|\fBj\fP|\fBg\fP|\fBm\fP|\fBt\fP ]
.SH DESCRIPTION
\fBps2raster\fP reads one or more \fIPostScript\fP files (or a file with a list of \fIPostScript\fP filenames) and modifies the BoundingBox
and PageSize in order that the raster image will have a size determined by the BoundingBox.
As an option, a tight BoundingBox may be computed.
.TP
\fIpsfiles\fP
Names of \fIPostScript\fP files to be converted. The output files will have the same name but with the
conventional extension name associated to the raster format (e.g. .jpg for the jpeg format).
.SH OPTIONS
.TP
.B \-A
Adjust the BoundingBox to the minimum required by the image content.
.TP
.B \-E
Set raster resolution in dpi [default = 300].
.TP
.B \-G
Full path to your ghostscript executable.
NOTE: For Unix systems this is generally not necessary.
However, under Windows, GhostScript is not added to the system's path. So either you do it yourself,\"'
or give the full path here. (e.g., \fB\-G\fPc:\\programs\\gs\\gs7.05\\bin\\gswin32c).
.TP
.B \-L
The \fIlistfile\fP is an ASCII file with the names of the \fIPostScript\fP files to be converted.
.TP
.B \-N
Do \fInot\fP remove auxiliary files (by default it does). Auxiliary files are built using as base the input
\fIPostScript\fP files and consist of:
psfile_tmpxx.eps -> \fIPostScript\fP with a modified BoundingBox
psTOraster.sc|bat -> script (or batch) with the ghostscript command that does the job.
Use this option to save the script and run it later with different settings.
.TP
.B \-T
Sets the output raster format, where \fBf\fP means PDF, \fBj\fP means JPEG, \fBg\fP means PNG,
\fBm\fP means PPM, and \fBt\fP means TIF [default is JPEG].
.SH EXAMPLE
To convert a the file psfile.ps to png using a tight BoundingBox and assuming that gs can be found in
your system's path:\"'
.br
.sp
\fBps2raster\fP psfile.ps \fB\-A \-Tg\fP
.SH "SEE ALSO"
.IR GMT (l)
