.TH PSMECA l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
psmeca \- Plot focal mechanisms on maps
.SH SYNOPSIS
.br
psmeca \fIfiles\fP \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP]
[ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ] [ \fB\-C\fP\fIpen\fP ] [ \fB\-D\fP\fIdepmin\fP/\fIdepmax\fP ]
[ \fB\-E\fP\fIfill\fP] [ \fB\-G\fP\fIfill\fP] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ]
[ \fB\-K\fP ] [ \fB\-L\fP[\fIpen\fP] ] [ \fB\-M\fP ] [ \fB\-N\fP ] [ \fB\-O\fP ]
[ \fB\-P\fP ] 
[ \fB\-S\fP\fI<symbol><scale>\fP[/\fBd\fP]] [ \fB\-T\fP\fInum_of_plane\fP[\fIpen\fP] ]
[ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] [ \fB\-V\fP ] [ \fB\-W\fP\fIpen\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ]
[ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-Z\fP\fIcptfile\fP] [ \fB\-z\fP ] 
[ \fB\-a\fP[\fIsize\fP[\fIP_symbol\fP[\fIT_symbol\fP]]] ] 
[ \fB\-g\fP\fIfill\fP ] [ \fB\-e\fP\fIfill\fP ] [ \fB\-o\fP\fP ] [ \fB\-p\fP\fIpen\fP ]
[ \fB\-t\fP\fIpen\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] [ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
.br
\fBpsmeca\fP reads data values from \fIfiles\fP [or standard input]
and generates \fIPostScript\fP code that will plot focal mechanisms
on a map.  Most options are the same as for \fBpsxy\fP.
The \fIPostScript\fP code is written to standard output.
.br
.sp
.SH ARGUMENTS
\fIfiles\fP
List one or more file-names. If no files are given, \fBpsmeca\fP will read standard input.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.TP
\fB\-S\fP
Selects the meaning of the columns in the data file 
.br
In order to use the same file to plot cross-sections, depth is in third column.
Nevertheless, it is possible to use "old style" \fBpsvelomeca\fP input files
without depth in third column using the \fB-o\fP option.
.br
.TP
\fB\-Sa\fIscale[c/i][/fontsize[/offset\fP[\fBu\fP]]]
Focal mechanisms in Aki and Richard convention.
\fIscale\fP adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude.  Scale is the size for 
magnitude = 5 in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
Use the \fB\-T\fP option
to render the beach ball transparent by drawing only the nodal planes
and the circumference.  The color or shade of the compressive
quadrants can be specified with the \fB\-G\fP option.  The color or shade
of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5,6\fP:
strike, dip and rake in degrees
.IP \fB7\fP:
magnitude
.IP \fB8,9\fP:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fP option.  Using 0,0 in columns
8 and 9 will plot the beach ball at the longtiude, latitude given in
columns 1 and 2.  The \fB\-:\fP option will interchange the order of
columns (1,2) and (8,9).
.IP \fB10\fP:
Text string to appear above the beach ball (optional).
.br
.sp
.TP
\fB\-Sc\fP\fIscale[c/i][/fontsize[/offset\fP[\fBu\fP]]]
Focal mechanisms in Harvard CMT convention.
\fIscale\fP adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude. Scale is the size for 
magnitude = 5 (that is M0 = 4.0E23 dynes-cm) 
in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
Use the \fB\-T\fP option
to render the beach ball transparent by drawing only the nodal planes
and the circumference. The color or shade of the compressive quadrants
can be specified with the \fB\-G\fP option.  The color or shade
of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns:
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5,6\fP:
strike, dip, and rake of plane 1
.IP \fB7,8,9\fP:
strike, dip, and rake of plane 2
.IP \fB10,11\fP:
mantissa and exponent of moment in dyne-cm
.IP \fB12,13\fP:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fP option.  Using (0,0) in
columns 11 and 12 will plot the beach ball at the longitude, latitude
given in columns 1 and 2.  The \fB\-:\fP option will interchange the order of
columns (1,2) and (12,13).
.IP \fB14\fP:
Text string to appear above the beach ball (optional).
.TP
\fB\-Sm\fP\fIscale[c/i][/fontsize[/offset\fP[\fBu\fP]]]
Seismic moment tensor (Harvard CMT, with zero trace). \fIscale\fP adjusts the
scaling of the radius of the "beach ball", which will be proportional 
to the magnitude. Scale is the size for magnitude = 5 (that is scalar seismic
moment = 4.0E23 dynes-cm)
in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
(\fB\-T\fP\fI0\fP option overlays best double couple transparently.)
Put \fB\-Sd\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]] to plot the only double couple part of moment tensor.
Put \fB\-Sz\fP\fIscale[/fontsize[/offset\fP[\fBu\fP]]] to plot anisotropic part of moment tensor (zero trace).
The color or shade of the compressive quadrants
can be specified with the \fB\-G\fP option.  The color or shade
of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5,6,7,8,9\fP:
mrr, mtt, mff, mrt, mrf, mtf in 10*exponent dynes-cm
.IP \fB10\fP:
exponent
.IP \fB11,12\fP:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fP option.  Using 0,0 in columns
9 and 10 will plot the beach ball at the longitude, latitude given in
columns 1 and 2.  The \fB\-:\fP option will interchange the order of
columns (1,2) and (9,10).
.IP \fB13\fP:
Text string to appear above the beach ball (optional).
.br
.sp
.TP
\fB\-Sp\fP\fIscale[c/i][/fontsize[/offset\fP[\fBu\fP]]]
Focal mechanisms given with partial data on both planes.
\fIscale\fP adjusts the scaling of the radius of the "beach ball",
which will be proportional to the magnitude. Scale is the size
for magnitude = 5 in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
The color or shade of the compressive quadrants
can be specified with the \fB\-G\fP option.  The color or shade
of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5\fP:
strike, dip of plane 1
.IP \fB6\fP:
strike of plane 2
.IP \fB7\fP:
must be -1/+1 for a normal/inverse fault
.IP \fB8\fP:
magnitude
.IP \fB9,10\fP:
longitude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fP option.  Using 0,0 in columns
9 and 10 will plot the beach ball at the longitude, latitude given in
columns 1 and 2.  The \fB\-:\fP option will interchange the order of
columns (1,2) and (9,10).
.IP \fB11\fP:
Text string to appear above the beach ball (optional).
.br
.sp
.TP
\fB\-Sx\fP\fIscale[c/i][/fontsize[/offset\fP[\fBu\fP]]]
Principal axis.
\fIscale\fP adjusts the scaling of the radius of the "beach ball", which will
be proportional to the magnitude. Scale is the size for magnitude = 5 (that is
seismic scalar moment = 4*10e+23 dynes-cm)
in inch (unless \fBc\fP, \fBi\fP, \fBm\fP, or \fBp\fP is appended).
(\fB\-T\fP\fI0\fP option overlays best double couple transparently.)
Put \fB\-Sy\fP\fIscale[c/i][/fontsize[/offset\fP[\fBu\fP]]] to plot the only double couple part of
moment tensor.
Put \fB\-St\fP\fIscale[c/i][/fontsize[/offset\fP[\fBu\fP]]] to plot zero trace moment tensor.
The color or shade of the compressive quadrants
can be specified with the \fB\-G\fP option.  The color or shade
of the extensive quadrants can be specified with the \fB\-E\fP option.
Parameters are expected to be in the following columns
.IP \fB1,2\fP:
longitude, latitude of event (\fB\-:\fP option interchanges order)
.IP \fB3\fP:
depth of event in kilometers
.IP \fB4,5,6,7,8,9,10,11,12\fP:
value (in 10*exponent dynes-cm), azimuth, plunge of T, N, P axis.
.IP \fB13\fP:
exponent
.IP \fB14,15\fP:
longtiude, latitude at which to place beach ball. Entries in these
columns are necessary with the \fB\-C\fP option.  Using 0,0 in columns
9 and 10 will plot the beach ball at the longitude, latitude given in
columns 1 and 2.  The \fB\-:\fP option will interchange the order of
columns (1,2) and (9,10).
.IP \fB16\fP:
Text string to appear above the beach ball (optional).
.br
.sp
.LP
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
\fB\-C\fP[\fIpen\fP][\fIpointsize\fP]
Offsets focal mechanisms to the longitude, latitude specified in the last
two columns of the input file before the (optional) text string.  A small
circle is plotted at the initial location and a line connects the beachball
to the circle.  Specify \fIpen\fP and/or \fIpointsize\fP to change the line
style and/or size of the circle. [Defaults: \fIpen\fP width = 1, color = 0/0/0,
texture = solid; \fIpointsize\fP 0].
.br
.TP
\fB\-D
\fIdepmin/depmax\fP
Plots events between depmin and depmax.
.br
.TP
\fB\-E\fP\fIfill\fP
Selects filling of extensive quadrants. Usually white.
Set the shade (0\-255) or color (r/g/b) [Default is 255/255/255].  
.br
.TP
\fB\-G\fP\fIfill\fP
Selects filling of focal mechanisms.  By
convention, the compressional quadrants of the focal mechanism beach
balls are shaded.  Set the shade (0\-255) or color (r/g/b) [Default is
0/0/0]. 
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
\fB\-L\fP[\fIpen\fP]
Draws the "beach ball" outline with \fIpen\fP attributes.
[Defaults width = 1, color = 0/0/0, texture = solid].
.br
.TP
\fB\-N
\fRDoes \fBNOT \fRskip symbols that fall outside frame boundary specified by
\fB\-R\fP [Default plots symbols inside frame only].
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
\fB\-T\fP[\fInum_of_planes\fP]
\fRPlots the nodal planes and outlines the bubble which is transparent.
If \fInum_of_planes\fP is
.br
      \fI0\fP: both nodal planes are plotted;
      \fI1\fP: only the first nodal plane is plotted;
      \fI2\fP: only the second nodal plane is plotted.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
\fB\-W
\fIpen\fP is a comma delimetered list of \fIwidth\fP, \fIcolor\fP and \fItexture\fP, each of which is optional.
\fIwidth\fP can be indicated as a measure (points, centimeters, inches) or as \fBfaint\fP, \fBthin\fP[\fBner\fP|\fBnest\fP],
\fBthick\fP[\fBer\fP|\fBest\fP], \fBfat\fP[\fBter\fP|\fBtest\fP], or \fBobese\fP.
\fIcolor\fP specifies a grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
\fItexture\fP is a combination of dashes `-' and dots `.'.
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
\fB\-Z\fIcptfile
\fRGive a color palette file and let compressive part color be determined by the z-value in the
third column. 
.br
.TP
\fB\-z
\fROverlay zero trace moment tensor.
.br
.TP
\fB\-a\fP[\fIsize\fP/[\fIP_axis_symbol\fP/[\fIT_axis_symbol\fP]]]
Computes and plots P and T axes with symbols. Optionally specify \fIsize\fP
and (separate) P and T axis symbols from the following:
(\fBc\fP) circle, (\fBd\fP) diamond, (\fBh\fP) hexagon,
(\fBi\fP) inverse triangle,
(\fBp\fP)point, (\fBs\fP) square, (\fBt\fP) triangle,
(\fBx\fP) cross. [Defaults: 0.2\fBc\fP/\fBc\fP/\fBc\fP or 0.08\fBi\fP/\fBc\fP/\fBc\fP.]
.br
.TP
\fB\-e\fP\fIfill\fP
\fRSelects filling of T axis symbol.
Set the shade (0\-255) or color (r/g/b). Default is white.  
.br
.TP
\fB\-g\fP\fIfill\fP
Selects filling of P axis symbol.
Set the shade (0\-255) or color (r/g/b). Default black.
.br
.TP
\fB-o\fP
Use the \fBpsvelomeca\fP input format without depth in the third column.
.br
.TP
\fB\-p\fP[\fIpen\fP]
Draws the P axis outline using default pen (see \fB\-W\fP), or sets
pen attributes.
.br
.TP
\fB\-t\fP[\fIpen\fP]
Draws the T axis outline using default pen (see \fB\-W\fP), or sets 
pen attributes.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
.sp
The following file should give a normal-faulting CMT mechanism:
.br
\fBpsmeca\fP \fB\-R\fP239/240/34/35.2 \fB\-Jm\fP4 \fB\-Sc\fP0.4 \fB\-H\fP1 <<END>! test.ps
.br
lon     lat    depth str dip slip  st dip slip mant exp plon plat
.br
239.384 34.556  12.  180  18  -88   0  72  -90  5.5  0   0    0
.br
END
.br
.sp
.SH "SEE ALSO"
.IR GMT (l),
.IR psbasemap (l),
.IR psxy (l)
.SH REFERENCES
.br
\fRBomford, G., Geodesy, 4th ed., Oxford University Press, 1980.
.br
Aki, K. and P. Richards, Quantitative Seismology, Freeman, 1980.
.br
F. A. Dahlen and Jeoren Trom, Theoretical Seismology, Princeton, 1998, p.167.
.br
Cliff Frohlich, Cliff's Nodes Concerning Plotting Nodal Lines for P, Sh and Sv\"'
.br
Seismological Research Letters, Volume 67, Number 1, January-February, 1996
.br
Thorne Lay, Terry C. Wallace, Modern Global Seismology, Academic Press, 1995, p.384.
.br
W.H. Press, S.A. Teukolsky, W.T. Vetterling, B.P. Flannery, Numerical Recipes in
 C, Cambridge University press (routine jacobi)
.SH AUTHORS
\fRGenevieve Patau
.br
CNRS UMR 7580
.br
Seismology Dept.
.br
Institut de Physique du Globe de Paris
.br
(patau@.ipgp.jussieu.fr)
