.TH X2SYS_DATALIST l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
x2sys_datalist \- A generic data-extractor for ASCII or binary files
.SH SYNOPSIS
\fBx2sys_datalist\fP \fItrack(s)\fP \fB\-T\fP\fITAG\fP [ \fB\-F\fP\fIname1,name2,...\fP ] 
[ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ]  [ \fB\-S\fP ] [ \fB\-V\fP ] [ \fB\-bo\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBx2sys_datalist\fP reads one or more files and produces a single ASCII [or binary] table. 
The files can be of any format, which must be descriped and passed with the
\fB\-T\fP option.  You may limit the output to a geographic region, and insist
that the output from several files be separated by a multiple segment header.
Only the named data fields will be output [Default selects all columns].
.TP
\fItracks\fP
Can be one or more binary or ASCII data files. To give a list of names,
use `cat tracks.lis`.  If the names are missing the suffix we will
append the suffix that goes with this \fITAG\fP.  Track files will be looked
for first in the current directory and second in all directories listed in
\fB$X2SYS_HOME\fP/\fITAG\fP_paths.txt (if it exists). [If \fB$X2SYS_HOME\fP
is not set it will default to \fB$GMTHOME\fP/share/x2sys].
.TP
.B \-T
Sets the data set \fITAG\fP which among other things sets the definition file.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-F
Give a comma-separated sub-set list of column names defined in the definition
file. [Default selects all data columns].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-M
Output a multisegment header between data from each track.  Note this option does not
imply anything about the input file; that information is conveyed via the system tag (\fB\-T\fP).
.TP
.B \-S
Suppress output records where all the data columns are NaN [Default will output all records].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
.SH EXAMPLES
To extract all data from the old-style MGG supplement file c2104.gmt, recognized by the tag MGG:
.br
.sp
\fBx2sys_datalist\fP c2104.gmt \fB\-T\fPmgg > myfile
.br
.sp
To make lon,lat, and depth input for \fBblockmean\fP and \fBsurface\fP using all the files
listed in the file tracks.lis and define by the tag TRK, but only the data that are inside the specified
area, and make output binary, run
.br
.sp
\fBx2sys_datalist\fP `cat tracks.lis` \fB\-T\fPTRK \fB\-F\fPlon,lat,depth \fB\-R\fP-40/-30/25/35 \fB\-bo\fP > alltopo.xyz
.SH "SEE ALSO"
.IR blockmean (l),
.IR GMT (l),
.IR surface (l),
.IR x2sys_cross (l)
