.TH HOTSPOTTER GMTMANSECTION "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
hotspotter \- Create CVA image from seamount flowlines 
.SH SYNOPSIS
\fBhotspotter\fP [\fIinfile(s)\fP] \fB\-E\fP\fIstage_file\fP 
\fB\-G\fP\fICVAgrid\fP \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] 
\fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] [ \fB\-C\fP ] [ \fB\-D\fP\fIfactor\fP ] [ \fB\-F\fP ] 
[ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-N\fP\fIupper_age\fP ] 
[ \fB\-T\fP ] [ \fB\-V\fP ] [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBhotspotter\fP reads (longitude, latitude, amplitude, radius, age) records
from \fIinfiles\fP  [or standard input] and calculates flowlines using the 
specified stage pole (Euler) rotations.  These flowlines are convolved with
the shape of the seamount (using a Gaussian shape given amplitude and radius
= 6 sigma) and added up to give a Cumulative Volcano Amplitude grid (CVA).
See option \fB\-:\fP on how to read (latitude,longitude,...) files.
.br
	No space between the option flag and the associated arguments.  Use upper case for the
option flags and lower case for modifiers.
.TP
\fIinfile(s)\fP
Data file(s) to be processed.  If not given, standard input is read.
.TP
.B \-E
Give file with stage poles and opening angles.  This file must contain
one record for each stage; each record must be of the following format:
.br
.sp
	lon lat tstart tstop ccw-angle
.br
.sp
where tstart and tstop are in Ma and the rest is in degrees.  The oldest stage
must be listed first.  tstart (tstop) is the age of the old (young) end of the
stage.  Blank lines and records whose first column contains # will be ignored.
.TP
.B \-G
Specify name for output grid file.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.SH OPTIONS
.TP
.B \-C
Expect Total Reconstruction Poles (Finite Poles) rather than Backward Stage Poles [Default]
File format is similar to the stage pole format except the youngest rotation must be listed
first and that the tstart column is optional (assumed to be 0 Ma).
.TP
.B \-D
Modify the sampling interval along flowlines.  Default [0.5] gives approximately 2 points within
each grid box.  Smaller factors gives higher resolutions at the expense of longer processing time.
.TP
.B \-F
Force pixel registration [Default is grid registration].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-N
Set the upper age to assign seamounts whose crustal age is unknown (i.e. NaN) [no upper age].
.TP
.B \-T
Truncate seamount ages exceeding the upper age set with \fB\-N\fP [no truncation].
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 5 input columns].
.SH EXAMPLES
To create a CVA image from the Pacific (x,y,z,r,t) data in the file seamounts.d,
using the DC85.d Euler poles, run
.br
.sp
\fBhotspotter\fP seamounts.d \fB\-E\fPDC85.d \fB\-G\fPCVA.grd \fB\-R\fP130/260/-66/60 \fB\-I\fP10\fBm \-N\fP145 \fB\-T \-V\fP
.br
.sp
This file can then be plotted with \fBgrdimage\fP.
.SH "SEE ALSO"
.IR GMT (GMTMANSECTION),
.IR grdimage (GMTMANSECTION),
.IR project (GMTMANSECTION),
.IR mapproject (GMTMANSECTION),
.IR backtracker (GMTMANSECTION),
.IR originator (GMTMANSECTION)
.SH REFERENCES
Wessel, P., 1999, "Hotspotting" tools released, EOS Trans. AGU, 80 (29), p. 319.
.br
