.TH X2SYS_CROSS GMTMANSECTION "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
\fBx2sys_cross\fP \- Find and compute Cross-Over Errors
.SH SYNOPSIS
\fBx2sys_cross\fP \fItrack(s)\fP \fB\-T\fP\fITAG\fP 
[ \fB\-Cc\fP|\fBf\fP|\fBg\fP|\fBe\fP ] [ \fB\-F\fP\fIflags\fP ] [ \fB\-Il\fP|\fBa\fP|\fBc\fP ] 
[ \fB\-J\fP\fIparameters\fP ] [ \fB\-K\fP\fIcombi.lis\fP] [ \fB\-O\fP ] 
[ \fB\-Nd\fP|\fBs\fP\fIunit\fP ] [ \fB\-Qe\fP|\fBi\fP ] [ \fB\-Sl\fP|\fBu\fP\fIspeed\fP ] 
[ \fB\-V\fP ][ \fB\-Wt\fP|\fBd\fP|\fBn\fP\fIsize\fP ] [ \fB\-2\fP ] [ \fB\-bo\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.SH DESCRIPTION
\fBx2sys_cross\fP is used to determine all intersections between ("external cross-overs") or within
("internal cross-overs") tracks, and report the time, position, distance along track,
heading and speed along each tracksegment, and the crossover and mean values for all observables.
The names of the tracks are passed on the command line.
By default, \fBx2sys_cross\fP will look for both external and internal cross-overs.  As an option,
you may choose to project all data using one of the map-projections prior to calculating the crossovers.
.TP
\fItracks\fP
Can be one or more binary or ASCII data files. To give a list of names,
use `cat tracks.lis`.  If the names are missing the suffix we will
append the suffix that goes with this \fITAG\fP.  Track files will be looked
for first in the current directory and second in all directories listed in
\fB$X2SYS_HOME\fP/\fITAG\fP_paths.txt (if it exists). [If \fB$X2SYS_HOME\fP
is not set it will default to \fB$GMTHOME\fP/share/x2sys].
.TP
.B \-T
Sets the data set \fITAG\fP which, among other things, sets the definition file.
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-C
Select procedure for along-track distance calculation:
.br
\fBc\fP Cartesian distances [Default].
.br
\fBf\fP Flat Earth distances.
.br
\fBg\fP Great circle distances.
.br
\fBe\fP Geodesic distances on current \fBGMT\fP ellipsoid.
.TP
.B \-F
Sets which columns to use.  Give a comma-separated list of column names;
this list must include \fBx\fP, \fBy\fP or \fBlon\fP, \fBlat\fP and ideally
\fBtime\fP [Default selects all columns].
.TP
.B \-I
Sets the interpolation mode. Choose among:
.br
\fBl\fP Linear interpolation [Default].
.br
\fBa\fP Akima spline interpolation.
.br
\fBc\fP Cubic spline interpolation.
.br
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-K
Only process the pair-combinations found in the file \fIcombi.lis\fP
[Default process all possible combinations among the specified files].
.TP
.B \-L
Output results using the old XOVER format [Default is X2SYS format].
This option should only be used with *.gmt-formatted MGD77 files.
.TP
.B \-N
Append \fBd\fP for distance or \fBs\fP for speed, then give the desired \fIunit\fP as
\fBe\fP (meter or m/s), \fBk\fP (km or km/hr), \fBm\fP (miles or miles/hr), or
\fBn\fP (nautical miles or knots).  [Default is \fB\-Ndk \-Nse\fP (km and m/s)].
.TP
.B \-Q
Append \fBe\fP for external crossovers only, and \fBi\fP for internal
crossovers only [Default is all crossovers].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest, and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
.TP
.B \-S
Defines window of track speeds.  If speeds are outside this window we do not
calculate a crossover. Specify
.br
	\fB\-Sl\fP sets lower speed [Default is 0].
.br
	\fB\-Su\fP sets upper speed [Default is Infinity].
.br
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-W
Give \fBt\fP, \fBd\fP, or \fBn\fP and append the corresponding
maximum time gap [Infinity], or distance gap [Infinity] (both in user units) allowed between
the two points immediately on either side of a crossover.  If the gap exceeds this maximum
gap we skip the crossover calculation.  For \fB\-Wn\fP, give the maximum number of points on
either side to use in the interpolation [3].
.TP
.B \-2
Report the values of each track at the crossover [Default reports the crossover value and the mean value].
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
.SH REMARKS
The COEs found are printed out to standard output in ASCII format (unless
\fB\-bo\fP is set).  When ASCII is chosen, the output format depends on
whether or not old-style XOVER output (\fB\-L\fP) has been selected.
If so, then the first record contains the file names and their start year,
whereas subsequent records have the data for each COE encountered.  The fields
written out are lat, lon, time along track #1 and #2,
x_gravity, x_magnetics, x_bathymetry, average gravity, average magnetics,
average bathymetry, heading along track #1 and #2. If
the default format is chosen then the header record starts with "> ", and
the output format for crossovers are first 10 columns that contain
x, y, time along track #1 and #2, distance along track #1 and #2,
heading along track #1 and #2, velocity along track #1 and #2, and
then pairs of (COE, average value) for each data type (or track-values; see \fB\-2\fP).
It is recommended that the Akima spline is used
instead of the natural cubic spline, since it is less sensitive to outliers
that tend to introduce wild oscillations in the interpolation.
.SH SIGN CONVENTION
If lega and legb are passed on the command line, then the COE value is Value
(lega) - Value (legb).
.SH EXAMPLES
To compute all internal crossovers in the gmt-formatted file c2104.gmt, and
output in the old XOVER format, using the tag MGG, try
.br
.sp
\fBx2sys_cross\fP c2104.gmt \fB\-L \-T\fPMGG > c2104.d
.br
.sp
To find the crossover locations with bathymetry between the two MGD77
files A13232.mgd77 and A99938.mgd77, using the MGD77 tag, try
.br
.sp
\fBx2sys_cross\fP A13232.mgd77 A99938.mgd77 \fB\-Qe \-T\fPNGD77 \fB\-F\fPlon,lat,depth > crossovers.d
.SH "SEE ALSO"
.IR GMT (GMTMANSECTION),
.IR x2sys_init (GMTMANSECTION)
.IR x2sys_datalist (GMTMANSECTION)
.IR x2sys_get (GMTMANSECTION)
.IR x2sys_put (GMTMANSECTION)
