#!/bin/sh
#
#	$Id: do_examples.sh,v 1.9 2007/09/13 17:36:35 remko Exp $
#
# Bourne script to test all GMT examples (sh versions).
# If one argument is given it is used as the bin path
# If a second arguemnt is used it is added to the library path

# Temporary change LANG to C
LANG=C

# First determine if awk is buggy:

result=`echo 1 | awk '{print sin($1)}'`
if [ $result = 1 ]; then
	answer=`which nawk`
	if [ $#answer = 1 ]; then
		export AWK=nawk
	else
		export AWK=gawk
	fi
else
	export AWK=awk
fi

# Extend executable and library path if requested

if [ $# -ge 1 ]; then
	cd ..
	top=`pwd`
	cd examples
	export PATH=$1:$PATH
	if [ $# = 2 ]; then
		export LD_LIBRARY_PATH=$2:${LD_LIBRARY_PATH:-/usr/lib}
	fi
fi

# Loop over all examples and run each job

for ex in ex??/job??.sh
do
	echo -n "Doing example $ex ... "
	cd `dirname $ex`
	\cp -f ../.gmtdefaults4.doc .gmtdefaults4
	sh `basename $ex`
	\rm -f .gmtdefaults4 .gmtcommands4
	cd ..
	echo "done"
done

echo "Completed all examples"
