/* Code automatically generated by mgd77netcdfhelper.sh
 * To be included by mgd77.c
 *
 *    Copyright (c) 2005-2007 by P. Wessel
 *    See README file for copying and redistribution conditions.
 */
 
void MGD77_Read_Header_Params (struct MGD77_CONTROL *F, struct MGD77_HEADER_PARAMS *P)
{
	/* Read the netCDF-encoded MGD77 header parameters as attributes of the data set.
	 * If orig is TRUE we will recover the original MGD77 parameters; otherwise we first
	 * look for revised parameters and fall back on the original if no revision is found. */
	
	MGD77_Get_Param (F, "Survey_Identifier", P->Survey_Identifier);
	MGD77_Get_Param (F, "Format_Acronym", P->Format_Acronym);
	MGD77_Get_Param (F, "Data_Center_File_Number", P->Data_Center_File_Number);
	MGD77_Get_Param (F, "Parameters_Surveyed_Code", P->Parameters_Surveyed_Code);
	MGD77_Get_Param (F, "File_Creation_Year", P->File_Creation_Year);
	MGD77_Get_Param (F, "File_Creation_Month", P->File_Creation_Month);
	MGD77_Get_Param (F, "File_Creation_Day", P->File_Creation_Day);
	MGD77_Get_Param (F, "Source_Institution", P->Source_Institution);
	MGD77_Get_Param (F, "Country", P->Country);
	MGD77_Get_Param (F, "Platform_Name", P->Platform_Name);
	MGD77_Get_Param (F, "Platform_Type_Code", &P->Platform_Type_Code);
	MGD77_Get_Param (F, "Platform_Type", P->Platform_Type);
	MGD77_Get_Param (F, "Chief_Scientist", P->Chief_Scientist);
	MGD77_Get_Param (F, "Project_Cruise_Leg", P->Project_Cruise_Leg);
	MGD77_Get_Param (F, "Funding", P->Funding);
	MGD77_Get_Param (F, "Survey_Departure_Year", P->Survey_Departure_Year);
	MGD77_Get_Param (F, "Survey_Departure_Month", P->Survey_Departure_Month);
	MGD77_Get_Param (F, "Survey_Departure_Day", P->Survey_Departure_Day);
	MGD77_Get_Param (F, "Port_of_Departure", P->Port_of_Departure);
	MGD77_Get_Param (F, "Survey_Arrival_Year", P->Survey_Arrival_Year);
	MGD77_Get_Param (F, "Survey_Arrival_Month", P->Survey_Arrival_Month);
	MGD77_Get_Param (F, "Survey_Arrival_Day", P->Survey_Arrival_Day);
	MGD77_Get_Param (F, "Port_of_Arrival", P->Port_of_Arrival);
	MGD77_Get_Param (F, "Navigation_Instrumentation", P->Navigation_Instrumentation);
	MGD77_Get_Param (F, "Geodetic_Datum_Position_Determination_Method", P->Geodetic_Datum_Position_Determination_Method);
	MGD77_Get_Param (F, "Bathymetry_Instrumentation", P->Bathymetry_Instrumentation);
	MGD77_Get_Param (F, "Bathymetry_Add_Forms_of_Data", P->Bathymetry_Add_Forms_of_Data);
	MGD77_Get_Param (F, "Magnetics_Instrumentation", P->Magnetics_Instrumentation);
	MGD77_Get_Param (F, "Magnetics_Add_Forms_of_Data", P->Magnetics_Add_Forms_of_Data);
	MGD77_Get_Param (F, "Gravity_Instrumentation", P->Gravity_Instrumentation);
	MGD77_Get_Param (F, "Gravity_Add_Forms_of_Data", P->Gravity_Add_Forms_of_Data);
	MGD77_Get_Param (F, "Seismic_Instrumentation", P->Seismic_Instrumentation);
	MGD77_Get_Param (F, "Seismic_Add_Forms_of_Data", P->Seismic_Add_Forms_of_Data);
	MGD77_Get_Param (F, "Format_Type", &P->Format_Type);
	MGD77_Get_Param (F, "Format_Description", P->Format_Description);
	MGD77_Get_Param (F, "Topmost_Latitude", P->Topmost_Latitude);
	MGD77_Get_Param (F, "Bottommost_Latitude", P->Bottommost_Latitude);
	MGD77_Get_Param (F, "Leftmost_Longitude", P->Leftmost_Longitude);
	MGD77_Get_Param (F, "Rightmost_Longitude", P->Rightmost_Longitude);
	MGD77_Get_Param (F, "Bathymetry_Digitizing_Rate", P->Bathymetry_Digitizing_Rate);
	MGD77_Get_Param (F, "Bathymetry_Sampling_Rate", P->Bathymetry_Sampling_Rate);
	MGD77_Get_Param (F, "Bathymetry_Assumed_Sound_Velocity", P->Bathymetry_Assumed_Sound_Velocity);
	MGD77_Get_Param (F, "Bathymetry_Datum_Code", P->Bathymetry_Datum_Code);
	MGD77_Get_Param (F, "Bathymetry_Interpolation_Scheme", P->Bathymetry_Interpolation_Scheme);
	MGD77_Get_Param (F, "Magnetics_Digitizing_Rate", P->Magnetics_Digitizing_Rate);
	MGD77_Get_Param (F, "Magnetics_Sampling_Rate", P->Magnetics_Sampling_Rate);
	MGD77_Get_Param (F, "Magnetics_Sensor_Tow_Distance", P->Magnetics_Sensor_Tow_Distance);
	MGD77_Get_Param (F, "Magnetics_Sensor_Depth", P->Magnetics_Sensor_Depth);
	MGD77_Get_Param (F, "Magnetics_Sensor_Separation", P->Magnetics_Sensor_Separation);
	MGD77_Get_Param (F, "Magnetics_Ref_Field_Code", P->Magnetics_Ref_Field_Code);
	MGD77_Get_Param (F, "Magnetics_Ref_Field", P->Magnetics_Ref_Field);
	MGD77_Get_Param (F, "Magnetics_Method_Applying_Res_Field", P->Magnetics_Method_Applying_Res_Field);
	MGD77_Get_Param (F, "Gravity_Digitizing_Rate", P->Gravity_Digitizing_Rate);
	MGD77_Get_Param (F, "Gravity_Sampling_Rate", P->Gravity_Sampling_Rate);
	MGD77_Get_Param (F, "Gravity_Theoretical_Formula_Code", &P->Gravity_Theoretical_Formula_Code);
	MGD77_Get_Param (F, "Gravity_Theoretical_Formula", P->Gravity_Theoretical_Formula);
	MGD77_Get_Param (F, "Gravity_Reference_System_Code", &P->Gravity_Reference_System_Code);
	MGD77_Get_Param (F, "Gravity_Reference_System", P->Gravity_Reference_System);
	MGD77_Get_Param (F, "Gravity_Corrections_Applied", P->Gravity_Corrections_Applied);
	MGD77_Get_Param (F, "Gravity_Departure_Base_Station", P->Gravity_Departure_Base_Station);
	MGD77_Get_Param (F, "Gravity_Departure_Base_Station_Name", P->Gravity_Departure_Base_Station_Name);
	MGD77_Get_Param (F, "Gravity_Arrival_Base_Station", P->Gravity_Arrival_Base_Station);
	MGD77_Get_Param (F, "Gravity_Arrival_Base_Station_Name", P->Gravity_Arrival_Base_Station_Name);
	MGD77_Get_Param (F, "Number_of_Ten_Degree_Identifiers", P->Number_of_Ten_Degree_Identifiers);
	MGD77_Get_Param (F, "Ten_Degree_Identifier", P->Ten_Degree_Identifier);
	MGD77_Get_Param (F, "Additional_Documentation_1", P->Additional_Documentation[0]);
	MGD77_Get_Param (F, "Additional_Documentation_2", P->Additional_Documentation[1]);
	MGD77_Get_Param (F, "Additional_Documentation_3", P->Additional_Documentation[2]);
	MGD77_Get_Param (F, "Additional_Documentation_4", P->Additional_Documentation[3]);
	MGD77_Get_Param (F, "Additional_Documentation_5", P->Additional_Documentation[4]);
	MGD77_Get_Param (F, "Additional_Documentation_6", P->Additional_Documentation[5]);
	MGD77_Get_Param (F, "Additional_Documentation_7", P->Additional_Documentation[6]);
}

void MGD77_Write_Header_Params (struct MGD77_CONTROL *F, struct MGD77_HEADER_PARAMS *P)
{
	/* Write the MGD77 header parameters as attributes of the netCDF-encoded data set */
	
	MGD77_Put_Param (F, "Survey_Identifier", strlen (P->Survey_Identifier), P->Survey_Identifier);
	MGD77_Put_Param (F, "Format_Acronym", strlen (P->Format_Acronym), P->Format_Acronym);
	MGD77_Put_Param (F, "Data_Center_File_Number", strlen (P->Data_Center_File_Number), P->Data_Center_File_Number);
	MGD77_Put_Param (F, "Parameters_Surveyed_Code", strlen (P->Parameters_Surveyed_Code), P->Parameters_Surveyed_Code);
	MGD77_Put_Param (F, "File_Creation_Year", strlen (P->File_Creation_Year), P->File_Creation_Year);
	MGD77_Put_Param (F, "File_Creation_Month", strlen (P->File_Creation_Month), P->File_Creation_Month);
	MGD77_Put_Param (F, "File_Creation_Day", strlen (P->File_Creation_Day), P->File_Creation_Day);
	MGD77_Put_Param (F, "Source_Institution", strlen (P->Source_Institution), P->Source_Institution);
	MGD77_Put_Param (F, "Country", strlen (P->Country), P->Country);
	MGD77_Put_Param (F, "Platform_Name", strlen (P->Platform_Name), P->Platform_Name);
	MGD77_Put_Param (F, "Platform_Type_Code", 1, &P->Platform_Type_Code);
	MGD77_Put_Param (F, "Platform_Type", strlen (P->Platform_Type), P->Platform_Type);
	MGD77_Put_Param (F, "Chief_Scientist", strlen (P->Chief_Scientist), P->Chief_Scientist);
	MGD77_Put_Param (F, "Project_Cruise_Leg", strlen (P->Project_Cruise_Leg), P->Project_Cruise_Leg);
	MGD77_Put_Param (F, "Funding", strlen (P->Funding), P->Funding);
	MGD77_Put_Param (F, "Survey_Departure_Year", strlen (P->Survey_Departure_Year), P->Survey_Departure_Year);
	MGD77_Put_Param (F, "Survey_Departure_Month", strlen (P->Survey_Departure_Month), P->Survey_Departure_Month);
	MGD77_Put_Param (F, "Survey_Departure_Day", strlen (P->Survey_Departure_Day), P->Survey_Departure_Day);
	MGD77_Put_Param (F, "Port_of_Departure", strlen (P->Port_of_Departure), P->Port_of_Departure);
	MGD77_Put_Param (F, "Survey_Arrival_Year", strlen (P->Survey_Arrival_Year), P->Survey_Arrival_Year);
	MGD77_Put_Param (F, "Survey_Arrival_Month", strlen (P->Survey_Arrival_Month), P->Survey_Arrival_Month);
	MGD77_Put_Param (F, "Survey_Arrival_Day", strlen (P->Survey_Arrival_Day), P->Survey_Arrival_Day);
	MGD77_Put_Param (F, "Port_of_Arrival", strlen (P->Port_of_Arrival), P->Port_of_Arrival);
	MGD77_Put_Param (F, "Navigation_Instrumentation", strlen (P->Navigation_Instrumentation), P->Navigation_Instrumentation);
	MGD77_Put_Param (F, "Geodetic_Datum_Position_Determination_Method", strlen (P->Geodetic_Datum_Position_Determination_Method), P->Geodetic_Datum_Position_Determination_Method);
	MGD77_Put_Param (F, "Bathymetry_Instrumentation", strlen (P->Bathymetry_Instrumentation), P->Bathymetry_Instrumentation);
	MGD77_Put_Param (F, "Bathymetry_Add_Forms_of_Data", strlen (P->Bathymetry_Add_Forms_of_Data), P->Bathymetry_Add_Forms_of_Data);
	MGD77_Put_Param (F, "Magnetics_Instrumentation", strlen (P->Magnetics_Instrumentation), P->Magnetics_Instrumentation);
	MGD77_Put_Param (F, "Magnetics_Add_Forms_of_Data", strlen (P->Magnetics_Add_Forms_of_Data), P->Magnetics_Add_Forms_of_Data);
	MGD77_Put_Param (F, "Gravity_Instrumentation", strlen (P->Gravity_Instrumentation), P->Gravity_Instrumentation);
	MGD77_Put_Param (F, "Gravity_Add_Forms_of_Data", strlen (P->Gravity_Add_Forms_of_Data), P->Gravity_Add_Forms_of_Data);
	MGD77_Put_Param (F, "Seismic_Instrumentation", strlen (P->Seismic_Instrumentation), P->Seismic_Instrumentation);
	MGD77_Put_Param (F, "Seismic_Add_Forms_of_Data", strlen (P->Seismic_Add_Forms_of_Data), P->Seismic_Add_Forms_of_Data);
	MGD77_Put_Param (F, "Format_Type", 1, &P->Format_Type);
	MGD77_Put_Param (F, "Format_Description", strlen (P->Format_Description), P->Format_Description);
	MGD77_Put_Param (F, "Topmost_Latitude", strlen (P->Topmost_Latitude), P->Topmost_Latitude);
	MGD77_Put_Param (F, "Bottommost_Latitude", strlen (P->Bottommost_Latitude), P->Bottommost_Latitude);
	MGD77_Put_Param (F, "Leftmost_Longitude", strlen (P->Leftmost_Longitude), P->Leftmost_Longitude);
	MGD77_Put_Param (F, "Rightmost_Longitude", strlen (P->Rightmost_Longitude), P->Rightmost_Longitude);
	MGD77_Put_Param (F, "Bathymetry_Digitizing_Rate", strlen (P->Bathymetry_Digitizing_Rate), P->Bathymetry_Digitizing_Rate);
	MGD77_Put_Param (F, "Bathymetry_Sampling_Rate", strlen (P->Bathymetry_Sampling_Rate), P->Bathymetry_Sampling_Rate);
	MGD77_Put_Param (F, "Bathymetry_Assumed_Sound_Velocity", strlen (P->Bathymetry_Assumed_Sound_Velocity), P->Bathymetry_Assumed_Sound_Velocity);
	MGD77_Put_Param (F, "Bathymetry_Datum_Code", strlen (P->Bathymetry_Datum_Code), P->Bathymetry_Datum_Code);
	MGD77_Put_Param (F, "Bathymetry_Interpolation_Scheme", strlen (P->Bathymetry_Interpolation_Scheme), P->Bathymetry_Interpolation_Scheme);
	MGD77_Put_Param (F, "Magnetics_Digitizing_Rate", strlen (P->Magnetics_Digitizing_Rate), P->Magnetics_Digitizing_Rate);
	MGD77_Put_Param (F, "Magnetics_Sampling_Rate", strlen (P->Magnetics_Sampling_Rate), P->Magnetics_Sampling_Rate);
	MGD77_Put_Param (F, "Magnetics_Sensor_Tow_Distance", strlen (P->Magnetics_Sensor_Tow_Distance), P->Magnetics_Sensor_Tow_Distance);
	MGD77_Put_Param (F, "Magnetics_Sensor_Depth", strlen (P->Magnetics_Sensor_Depth), P->Magnetics_Sensor_Depth);
	MGD77_Put_Param (F, "Magnetics_Sensor_Separation", strlen (P->Magnetics_Sensor_Separation), P->Magnetics_Sensor_Separation);
	MGD77_Put_Param (F, "Magnetics_Ref_Field_Code", strlen (P->Magnetics_Ref_Field_Code), P->Magnetics_Ref_Field_Code);
	MGD77_Put_Param (F, "Magnetics_Ref_Field", strlen (P->Magnetics_Ref_Field), P->Magnetics_Ref_Field);
	MGD77_Put_Param (F, "Magnetics_Method_Applying_Res_Field", strlen (P->Magnetics_Method_Applying_Res_Field), P->Magnetics_Method_Applying_Res_Field);
	MGD77_Put_Param (F, "Gravity_Digitizing_Rate", strlen (P->Gravity_Digitizing_Rate), P->Gravity_Digitizing_Rate);
	MGD77_Put_Param (F, "Gravity_Sampling_Rate", strlen (P->Gravity_Sampling_Rate), P->Gravity_Sampling_Rate);
	MGD77_Put_Param (F, "Gravity_Theoretical_Formula_Code", 1, &P->Gravity_Theoretical_Formula_Code);
	MGD77_Put_Param (F, "Gravity_Theoretical_Formula", strlen (P->Gravity_Theoretical_Formula), P->Gravity_Theoretical_Formula);
	MGD77_Put_Param (F, "Gravity_Reference_System_Code", 1, &P->Gravity_Reference_System_Code);
	MGD77_Put_Param (F, "Gravity_Reference_System", strlen (P->Gravity_Reference_System), P->Gravity_Reference_System);
	MGD77_Put_Param (F, "Gravity_Corrections_Applied", strlen (P->Gravity_Corrections_Applied), P->Gravity_Corrections_Applied);
	MGD77_Put_Param (F, "Gravity_Departure_Base_Station", strlen (P->Gravity_Departure_Base_Station), P->Gravity_Departure_Base_Station);
	MGD77_Put_Param (F, "Gravity_Departure_Base_Station_Name", strlen (P->Gravity_Departure_Base_Station_Name), P->Gravity_Departure_Base_Station_Name);
	MGD77_Put_Param (F, "Gravity_Arrival_Base_Station", strlen (P->Gravity_Arrival_Base_Station), P->Gravity_Arrival_Base_Station);
	MGD77_Put_Param (F, "Gravity_Arrival_Base_Station_Name", strlen (P->Gravity_Arrival_Base_Station_Name), P->Gravity_Arrival_Base_Station_Name);
	MGD77_Put_Param (F, "Number_of_Ten_Degree_Identifiers", strlen (P->Number_of_Ten_Degree_Identifiers), P->Number_of_Ten_Degree_Identifiers);
	MGD77_Put_Param (F, "Ten_Degree_Identifier", strlen (P->Ten_Degree_Identifier), P->Ten_Degree_Identifier);
	MGD77_Put_Param (F, "Additional_Documentation_1", strlen (P->Additional_Documentation[0]), P->Additional_Documentation[0]);
	MGD77_Put_Param (F, "Additional_Documentation_2", strlen (P->Additional_Documentation[1]), P->Additional_Documentation[1]);
	MGD77_Put_Param (F, "Additional_Documentation_3", strlen (P->Additional_Documentation[2]), P->Additional_Documentation[2]);
	MGD77_Put_Param (F, "Additional_Documentation_4", strlen (P->Additional_Documentation[3]), P->Additional_Documentation[3]);
	MGD77_Put_Param (F, "Additional_Documentation_5", strlen (P->Additional_Documentation[4]), P->Additional_Documentation[4]);
	MGD77_Put_Param (F, "Additional_Documentation_6", strlen (P->Additional_Documentation[5]), P->Additional_Documentation[5]);
	MGD77_Put_Param (F, "Additional_Documentation_7", strlen (P->Additional_Documentation[6]), P->Additional_Documentation[6]);
}

void MGD77_Dump_Header_Params (struct MGD77_CONTROL *F, struct MGD77_HEADER_PARAMS *P)
{
	char word[2] = { '\0', '\0'}, EOL = '\n';

	/* Write all the individual MGD77 header parameters to stdout */

	if (F->Want_Header_Item[0]) printf ("%s %44s :%s%c", F->NGDC_id, "Survey_Identifier", P->Survey_Identifier, EOL);
	if (F->Want_Header_Item[1]) printf ("%s %44s :%s%c", F->NGDC_id, "Format_Acronym", P->Format_Acronym, EOL);
	if (F->Want_Header_Item[2]) printf ("%s %44s :%s%c", F->NGDC_id, "Data_Center_File_Number", P->Data_Center_File_Number, EOL);
	if (F->Want_Header_Item[3]) printf ("%s %44s :%s%c", F->NGDC_id, "Parameters_Surveyed_Code", P->Parameters_Surveyed_Code, EOL);
	if (F->Want_Header_Item[4]) printf ("%s %44s :%s%c", F->NGDC_id, "File_Creation_Year", P->File_Creation_Year, EOL);
	if (F->Want_Header_Item[5]) printf ("%s %44s :%s%c", F->NGDC_id, "File_Creation_Month", P->File_Creation_Month, EOL);
	if (F->Want_Header_Item[6]) printf ("%s %44s :%s%c", F->NGDC_id, "File_Creation_Day", P->File_Creation_Day, EOL);
	if (F->Want_Header_Item[7]) printf ("%s %44s :%s%c", F->NGDC_id, "Source_Institution", P->Source_Institution, EOL);
	if (F->Want_Header_Item[8]) printf ("%s %44s :%s%c", F->NGDC_id, "Country", P->Country, EOL);
	if (F->Want_Header_Item[9]) printf ("%s %44s :%s%c", F->NGDC_id, "Platform_Name", P->Platform_Name, EOL);
	word[0] = P->Platform_Type_Code;
	if (F->Want_Header_Item[10]) printf ("%s %44s :%s%c", F->NGDC_id, "Platform_Type_Code", word, EOL);
	if (F->Want_Header_Item[11]) printf ("%s %44s :%s%c", F->NGDC_id, "Platform_Type", P->Platform_Type, EOL);
	if (F->Want_Header_Item[12]) printf ("%s %44s :%s%c", F->NGDC_id, "Chief_Scientist", P->Chief_Scientist, EOL);
	if (F->Want_Header_Item[13]) printf ("%s %44s :%s%c", F->NGDC_id, "Project_Cruise_Leg", P->Project_Cruise_Leg, EOL);
	if (F->Want_Header_Item[14]) printf ("%s %44s :%s%c", F->NGDC_id, "Funding", P->Funding, EOL);
	if (F->Want_Header_Item[15]) printf ("%s %44s :%s%c", F->NGDC_id, "Survey_Departure_Year", P->Survey_Departure_Year, EOL);
	if (F->Want_Header_Item[16]) printf ("%s %44s :%s%c", F->NGDC_id, "Survey_Departure_Month", P->Survey_Departure_Month, EOL);
	if (F->Want_Header_Item[17]) printf ("%s %44s :%s%c", F->NGDC_id, "Survey_Departure_Day", P->Survey_Departure_Day, EOL);
	if (F->Want_Header_Item[18]) printf ("%s %44s :%s%c", F->NGDC_id, "Port_of_Departure", P->Port_of_Departure, EOL);
	if (F->Want_Header_Item[19]) printf ("%s %44s :%s%c", F->NGDC_id, "Survey_Arrival_Year", P->Survey_Arrival_Year, EOL);
	if (F->Want_Header_Item[20]) printf ("%s %44s :%s%c", F->NGDC_id, "Survey_Arrival_Month", P->Survey_Arrival_Month, EOL);
	if (F->Want_Header_Item[21]) printf ("%s %44s :%s%c", F->NGDC_id, "Survey_Arrival_Day", P->Survey_Arrival_Day, EOL);
	if (F->Want_Header_Item[22]) printf ("%s %44s :%s%c", F->NGDC_id, "Port_of_Arrival", P->Port_of_Arrival, EOL);
	if (F->Want_Header_Item[23]) printf ("%s %44s :%s%c", F->NGDC_id, "Navigation_Instrumentation", P->Navigation_Instrumentation, EOL);
	if (F->Want_Header_Item[24]) printf ("%s %44s :%s%c", F->NGDC_id, "Geodetic_Datum_Position_Determination_Method", P->Geodetic_Datum_Position_Determination_Method, EOL);
	if (F->Want_Header_Item[25]) printf ("%s %44s :%s%c", F->NGDC_id, "Bathymetry_Instrumentation", P->Bathymetry_Instrumentation, EOL);
	if (F->Want_Header_Item[26]) printf ("%s %44s :%s%c", F->NGDC_id, "Bathymetry_Add_Forms_of_Data", P->Bathymetry_Add_Forms_of_Data, EOL);
	if (F->Want_Header_Item[27]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Instrumentation", P->Magnetics_Instrumentation, EOL);
	if (F->Want_Header_Item[28]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Add_Forms_of_Data", P->Magnetics_Add_Forms_of_Data, EOL);
	if (F->Want_Header_Item[29]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Instrumentation", P->Gravity_Instrumentation, EOL);
	if (F->Want_Header_Item[30]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Add_Forms_of_Data", P->Gravity_Add_Forms_of_Data, EOL);
	if (F->Want_Header_Item[31]) printf ("%s %44s :%s%c", F->NGDC_id, "Seismic_Instrumentation", P->Seismic_Instrumentation, EOL);
	if (F->Want_Header_Item[32]) printf ("%s %44s :%s%c", F->NGDC_id, "Seismic_Add_Forms_of_Data", P->Seismic_Add_Forms_of_Data, EOL);
	word[0] = P->Format_Type;
	if (F->Want_Header_Item[33]) printf ("%s %44s :%s%c", F->NGDC_id, "Format_Type", word, EOL);
	if (F->Want_Header_Item[34]) printf ("%s %44s :%s%c", F->NGDC_id, "Format_Description", P->Format_Description, EOL);
	if (F->Want_Header_Item[35]) printf ("%s %44s :%s%c", F->NGDC_id, "Topmost_Latitude", P->Topmost_Latitude, EOL);
	if (F->Want_Header_Item[36]) printf ("%s %44s :%s%c", F->NGDC_id, "Bottommost_Latitude", P->Bottommost_Latitude, EOL);
	if (F->Want_Header_Item[37]) printf ("%s %44s :%s%c", F->NGDC_id, "Leftmost_Longitude", P->Leftmost_Longitude, EOL);
	if (F->Want_Header_Item[38]) printf ("%s %44s :%s%c", F->NGDC_id, "Rightmost_Longitude", P->Rightmost_Longitude, EOL);
	if (F->Want_Header_Item[39]) printf ("%s %44s :%s%c", F->NGDC_id, "Bathymetry_Digitizing_Rate", P->Bathymetry_Digitizing_Rate, EOL);
	if (F->Want_Header_Item[40]) printf ("%s %44s :%s%c", F->NGDC_id, "Bathymetry_Sampling_Rate", P->Bathymetry_Sampling_Rate, EOL);
	if (F->Want_Header_Item[41]) printf ("%s %44s :%s%c", F->NGDC_id, "Bathymetry_Assumed_Sound_Velocity", P->Bathymetry_Assumed_Sound_Velocity, EOL);
	if (F->Want_Header_Item[42]) printf ("%s %44s :%s%c", F->NGDC_id, "Bathymetry_Datum_Code", P->Bathymetry_Datum_Code, EOL);
	if (F->Want_Header_Item[43]) printf ("%s %44s :%s%c", F->NGDC_id, "Bathymetry_Interpolation_Scheme", P->Bathymetry_Interpolation_Scheme, EOL);
	if (F->Want_Header_Item[44]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Digitizing_Rate", P->Magnetics_Digitizing_Rate, EOL);
	if (F->Want_Header_Item[45]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Sampling_Rate", P->Magnetics_Sampling_Rate, EOL);
	if (F->Want_Header_Item[46]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Sensor_Tow_Distance", P->Magnetics_Sensor_Tow_Distance, EOL);
	if (F->Want_Header_Item[47]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Sensor_Depth", P->Magnetics_Sensor_Depth, EOL);
	if (F->Want_Header_Item[48]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Sensor_Separation", P->Magnetics_Sensor_Separation, EOL);
	if (F->Want_Header_Item[49]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Ref_Field_Code", P->Magnetics_Ref_Field_Code, EOL);
	if (F->Want_Header_Item[50]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Ref_Field", P->Magnetics_Ref_Field, EOL);
	if (F->Want_Header_Item[51]) printf ("%s %44s :%s%c", F->NGDC_id, "Magnetics_Method_Applying_Res_Field", P->Magnetics_Method_Applying_Res_Field, EOL);
	if (F->Want_Header_Item[52]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Digitizing_Rate", P->Gravity_Digitizing_Rate, EOL);
	if (F->Want_Header_Item[53]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Sampling_Rate", P->Gravity_Sampling_Rate, EOL);
	word[0] = P->Gravity_Theoretical_Formula_Code;
	if (F->Want_Header_Item[54]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Theoretical_Formula_Code", word, EOL);
	if (F->Want_Header_Item[55]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Theoretical_Formula", P->Gravity_Theoretical_Formula, EOL);
	word[0] = P->Gravity_Reference_System_Code;
	if (F->Want_Header_Item[56]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Reference_System_Code", word, EOL);
	if (F->Want_Header_Item[57]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Reference_System", P->Gravity_Reference_System, EOL);
	if (F->Want_Header_Item[58]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Corrections_Applied", P->Gravity_Corrections_Applied, EOL);
	if (F->Want_Header_Item[59]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Departure_Base_Station", P->Gravity_Departure_Base_Station, EOL);
	if (F->Want_Header_Item[60]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Departure_Base_Station_Name", P->Gravity_Departure_Base_Station_Name, EOL);
	if (F->Want_Header_Item[61]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Arrival_Base_Station", P->Gravity_Arrival_Base_Station, EOL);
	if (F->Want_Header_Item[62]) printf ("%s %44s :%s%c", F->NGDC_id, "Gravity_Arrival_Base_Station_Name", P->Gravity_Arrival_Base_Station_Name, EOL);
	if (F->Want_Header_Item[63]) printf ("%s %44s :%s%c", F->NGDC_id, "Number_of_Ten_Degree_Identifiers", P->Number_of_Ten_Degree_Identifiers, EOL);
	if (F->Want_Header_Item[64]) printf ("%s %44s :%s%c", F->NGDC_id, "Ten_Degree_Identifier", P->Ten_Degree_Identifier, EOL);
	if (F->Want_Header_Item[65]) printf ("%s %44s :%s%c", F->NGDC_id, "Additional_Documentation", P->Additional_Documentation[0], EOL);
	if (F->Want_Header_Item[65]) printf ("%s %44s :%s%c", F->NGDC_id, "Additional_Documentation", P->Additional_Documentation[1], EOL);
	if (F->Want_Header_Item[65]) printf ("%s %44s :%s%c", F->NGDC_id, "Additional_Documentation", P->Additional_Documentation[2], EOL);
	if (F->Want_Header_Item[65]) printf ("%s %44s :%s%c", F->NGDC_id, "Additional_Documentation", P->Additional_Documentation[3], EOL);
	if (F->Want_Header_Item[65]) printf ("%s %44s :%s%c", F->NGDC_id, "Additional_Documentation", P->Additional_Documentation[4], EOL);
	if (F->Want_Header_Item[65]) printf ("%s %44s :%s%c", F->NGDC_id, "Additional_Documentation", P->Additional_Documentation[5], EOL);
	if (F->Want_Header_Item[65]) printf ("%s %44s :%s%c", F->NGDC_id, "Additional_Documentation", P->Additional_Documentation[6], EOL);
}

void MGD77_Reset_Header_Params (struct MGD77_CONTROL *F)
{
	/* Remove the revised MGD77 header attributes so we return to the original values.
	 * Here we simply ignore return values since many of these are presumably unknown attributes.
	 * File is assumed to be in define mode. */
	
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Identifier_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Format_Acronym_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Data_Center_File_Number_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Parameters_Surveyed_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "File_Creation_Year_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "File_Creation_Month_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "File_Creation_Day_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Source_Institution_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Country_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Platform_Name_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Platform_Type_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Platform_Type_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Chief_Scientist_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Project_Cruise_Leg_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Funding_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Departure_Year_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Departure_Month_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Departure_Day_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Port_of_Departure_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Arrival_Year_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Arrival_Month_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Survey_Arrival_Day_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Port_of_Arrival_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Navigation_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Geodetic_Datum_Position_Determination_Method_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Add_Forms_of_Data_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Add_Forms_of_Data_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Add_Forms_of_Data_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Seismic_Instrumentation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Seismic_Add_Forms_of_Data_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Format_Type_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Format_Description_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Topmost_Latitude_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bottommost_Latitude_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Leftmost_Longitude_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Rightmost_Longitude_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Digitizing_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Sampling_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Assumed_Sound_Velocity_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Datum_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Bathymetry_Interpolation_Scheme_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Digitizing_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Sampling_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Sensor_Tow_Distance_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Sensor_Depth_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Sensor_Separation_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Ref_Field_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Ref_Field_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Magnetics_Method_Applying_Res_Field_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Digitizing_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Sampling_Rate_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Theoretical_Formula_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Theoretical_Formula_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Reference_System_Code_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Reference_System_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Corrections_Applied_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Departure_Base_Station_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Departure_Base_Station_Name_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Arrival_Base_Station_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Gravity_Arrival_Base_Station_Name_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Number_of_Ten_Degree_Identifiers_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Ten_Degree_Identifier_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_1_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_2_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_3_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_4_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_5_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_6_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "Additional_Documentation_7_REVISED");
	(void) nc_del_att (F->nc_id, NC_GLOBAL, "E77");
}

void MGD77_Get_Param (struct MGD77_CONTROL *F, char *name, char *value)
{	/* Get a single parameter: original if requested, otherwise check for revised value first */

	if (!F->original) {	/* Must look for revised attribute first */
		char Att[64];
		sprintf (Att, "%s_REVISED", name);	/* Revised attributes have _REVISED at the end of their names */
		if (nc_get_att_text (F->nc_id, NC_GLOBAL, Att, value) == NC_NOERR)	return;	/* Found a revised attribute */
	}
	
	/* We get here if we want the original or could not find a revised value */
	
	MGD77_nc_status (nc_get_att_text (F->nc_id, NC_GLOBAL, name, value));
}

void MGD77_Put_Param (struct MGD77_CONTROL *F, char *name, int length, char *value)
{	/* Place a single revised parameter: use original attribute if requested;
	 * otherwise use a revised attribute name.
	 * FUnction assumes we are in define mode. */

	if (F->original)	/* Use original attribute name */
		MGD77_nc_status (nc_put_att_text (F->nc_id, NC_GLOBAL, name, length, value));
	else {	/* Create revised attribute first */
		char Att[64];
		sprintf (Att, "%s_REVISED", name);	/* Revised attributes have _REVISED at the end of their names */
		MGD77_nc_status (nc_put_att_text (F->nc_id, NC_GLOBAL, Att, length, value));
	}
}
 
struct MGD77_HEADER_LOOKUP MGD77_Header_Lookup[MGD77_N_HEADER_PARAMS] = {
	{ "Survey_Identifier"                           ,   9,  1,  2,  TRUE, NULL },
	{ "Format_Acronym"                              ,   6,  1,  3,  TRUE, NULL },
	{ "Data_Center_File_Number"                     ,   9,  1,  4,  TRUE, NULL },
	{ "Parameters_Surveyed_Code"                    ,   6,  1,  5,  TRUE, NULL },
	{ "File_Creation_Year"                          ,   5,  1, 10,  TRUE, NULL },
	{ "File_Creation_Month"                         ,   3,  1, 11,  TRUE, NULL },
	{ "File_Creation_Day"                           ,   3,  1, 12,  TRUE, NULL },
	{ "Source_Institution"                          ,  40,  1, 13, FALSE, NULL },
	{ "Country"                                     ,  19,  2,  1, FALSE, NULL },
	{ "Platform_Name"                               ,  22,  2,  2, FALSE, NULL },
	{ "Platform_Type_Code"                          ,   1,  2,  3,  TRUE, NULL },
	{ "Platform_Type"                               ,   7,  2,  4, FALSE, NULL },
	{ "Chief_Scientist"                             ,  33,  2,  5, FALSE, NULL },
	{ "Project_Cruise_Leg"                          ,  59,  3,  1, FALSE, NULL },
	{ "Funding"                                     ,  21,  3,  2, FALSE, NULL },
	{ "Survey_Departure_Year"                       ,   5,  4,  1,  TRUE, NULL },
	{ "Survey_Departure_Month"                      ,   3,  4,  2,  TRUE, NULL },
	{ "Survey_Departure_Day"                        ,   3,  4,  3,  TRUE, NULL },
	{ "Port_of_Departure"                           ,  33,  4,  4, FALSE, NULL },
	{ "Survey_Arrival_Year"                         ,   5,  4,  5,  TRUE, NULL },
	{ "Survey_Arrival_Month"                        ,   3,  4,  6,  TRUE, NULL },
	{ "Survey_Arrival_Day"                          ,   3,  4,  7,  TRUE, NULL },
	{ "Port_of_Arrival"                             ,  31,  4,  8, FALSE, NULL },
	{ "Navigation_Instrumentation"                  ,  41,  5,  1, FALSE, NULL },
	{ "Geodetic_Datum_Position_Determination_Method",  39,  5,  2, FALSE, NULL },
	{ "Bathymetry_Instrumentation"                  ,  41,  6,  1, FALSE, NULL },
	{ "Bathymetry_Add_Forms_of_Data"                ,  39,  6,  2, FALSE, NULL },
	{ "Magnetics_Instrumentation"                   ,  41,  7,  1, FALSE, NULL },
	{ "Magnetics_Add_Forms_of_Data"                 ,  39,  7,  2, FALSE, NULL },
	{ "Gravity_Instrumentation"                     ,  41,  8,  1, FALSE, NULL },
	{ "Gravity_Add_Forms_of_Data"                   ,  39,  8,  2, FALSE, NULL },
	{ "Seismic_Instrumentation"                     ,  41,  9,  1, FALSE, NULL },
	{ "Seismic_Add_Forms_of_Data"                   ,  39,  9,  2, FALSE, NULL },
	{ "Format_Type"                                 ,   1, 10,  1,  TRUE, NULL },
	{ "Format_Description"                          ,  95, 10,  2,  TRUE, NULL },
	{ "Topmost_Latitude"                            ,   4, 11,  1,  TRUE, NULL },
	{ "Bottommost_Latitude"                         ,   4, 11,  2,  TRUE, NULL },
	{ "Leftmost_Longitude"                          ,   5, 11,  3,  TRUE, NULL },
	{ "Rightmost_Longitude"                         ,   5, 11,  4,  TRUE, NULL },
	{ "Bathymetry_Digitizing_Rate"                  ,   4, 12,  1,  TRUE, NULL },
	{ "Bathymetry_Sampling_Rate"                    ,  13, 12,  2, FALSE, NULL },
	{ "Bathymetry_Assumed_Sound_Velocity"           ,   6, 12,  3,  TRUE, NULL },
	{ "Bathymetry_Datum_Code"                       ,   3, 12,  4,  TRUE, NULL },
	{ "Bathymetry_Interpolation_Scheme"             ,  57, 12,  5, FALSE, NULL },
	{ "Magnetics_Digitizing_Rate"                   ,   4, 13,  1,  TRUE, NULL },
	{ "Magnetics_Sampling_Rate"                     ,   3, 13,  2,  TRUE, NULL },
	{ "Magnetics_Sensor_Tow_Distance"               ,   5, 13,  3,  TRUE, NULL },
	{ "Magnetics_Sensor_Depth"                      ,   6, 13,  4,  TRUE, NULL },
	{ "Magnetics_Sensor_Separation"                 ,   4, 13,  5,  TRUE, NULL },
	{ "Magnetics_Ref_Field_Code"                    ,   3, 13,  6,  TRUE, NULL },
	{ "Magnetics_Ref_Field"                         ,  13, 13,  7,  TRUE, NULL },
	{ "Magnetics_Method_Applying_Res_Field"         ,  48, 13,  8, FALSE, NULL },
	{ "Gravity_Digitizing_Rate"                     ,   4, 14,  1,  TRUE, NULL },
	{ "Gravity_Sampling_Rate"                       ,   3, 14,  2,  TRUE, NULL },
	{ "Gravity_Theoretical_Formula_Code"            ,   1, 14,  3,  TRUE, NULL },
	{ "Gravity_Theoretical_Formula"                 ,  18, 14,  4, FALSE, NULL },
	{ "Gravity_Reference_System_Code"               ,   1, 14,  5,  TRUE, NULL },
	{ "Gravity_Reference_System"                    ,  17, 14,  6, FALSE, NULL },
	{ "Gravity_Corrections_Applied"                 ,  39, 14,  7, FALSE, NULL },
	{ "Gravity_Departure_Base_Station"              ,   8, 15,  1,  TRUE, NULL },
	{ "Gravity_Departure_Base_Station_Name"         ,  34, 15,  2, FALSE, NULL },
	{ "Gravity_Arrival_Base_Station"                ,   8, 15,  3,  TRUE, NULL },
	{ "Gravity_Arrival_Base_Station_Name"           ,  32, 15,  4, FALSE, NULL },
	{ "Number_of_Ten_Degree_Identifiers"            ,   3, 16,  1,  TRUE, NULL },
	{ "Ten_Degree_Identifier"                       , 151, 16,  2,  TRUE, NULL },
	{ "Additional_Documentation"                    ,   7, 18,  1, FALSE, NULL },
};

void MGD77_Init_Ptr (struct MGD77_HEADER_LOOKUP *H, struct MGD77_HEADER_PARAMS *P)
{	/* Assigns array of pointers to each idividual parameter */

	H[0].ptr = P->Survey_Identifier;
	H[1].ptr = P->Format_Acronym;
	H[2].ptr = P->Data_Center_File_Number;
	H[3].ptr = P->Parameters_Surveyed_Code;
	H[4].ptr = P->File_Creation_Year;
	H[5].ptr = P->File_Creation_Month;
	H[6].ptr = P->File_Creation_Day;
	H[7].ptr = P->Source_Institution;
	H[8].ptr = P->Country;
	H[9].ptr = P->Platform_Name;
	H[10].ptr = &P->Platform_Type_Code;
	H[11].ptr = P->Platform_Type;
	H[12].ptr = P->Chief_Scientist;
	H[13].ptr = P->Project_Cruise_Leg;
	H[14].ptr = P->Funding;
	H[15].ptr = P->Survey_Departure_Year;
	H[16].ptr = P->Survey_Departure_Month;
	H[17].ptr = P->Survey_Departure_Day;
	H[18].ptr = P->Port_of_Departure;
	H[19].ptr = P->Survey_Arrival_Year;
	H[20].ptr = P->Survey_Arrival_Month;
	H[21].ptr = P->Survey_Arrival_Day;
	H[22].ptr = P->Port_of_Arrival;
	H[23].ptr = P->Navigation_Instrumentation;
	H[24].ptr = P->Geodetic_Datum_Position_Determination_Method;
	H[25].ptr = P->Bathymetry_Instrumentation;
	H[26].ptr = P->Bathymetry_Add_Forms_of_Data;
	H[27].ptr = P->Magnetics_Instrumentation;
	H[28].ptr = P->Magnetics_Add_Forms_of_Data;
	H[29].ptr = P->Gravity_Instrumentation;
	H[30].ptr = P->Gravity_Add_Forms_of_Data;
	H[31].ptr = P->Seismic_Instrumentation;
	H[32].ptr = P->Seismic_Add_Forms_of_Data;
	H[33].ptr = &P->Format_Type;
	H[34].ptr = P->Format_Description;
	H[35].ptr = P->Topmost_Latitude;
	H[36].ptr = P->Bottommost_Latitude;
	H[37].ptr = P->Leftmost_Longitude;
	H[38].ptr = P->Rightmost_Longitude;
	H[39].ptr = P->Bathymetry_Digitizing_Rate;
	H[40].ptr = P->Bathymetry_Sampling_Rate;
	H[41].ptr = P->Bathymetry_Assumed_Sound_Velocity;
	H[42].ptr = P->Bathymetry_Datum_Code;
	H[43].ptr = P->Bathymetry_Interpolation_Scheme;
	H[44].ptr = P->Magnetics_Digitizing_Rate;
	H[45].ptr = P->Magnetics_Sampling_Rate;
	H[46].ptr = P->Magnetics_Sensor_Tow_Distance;
	H[47].ptr = P->Magnetics_Sensor_Depth;
	H[48].ptr = P->Magnetics_Sensor_Separation;
	H[49].ptr = P->Magnetics_Ref_Field_Code;
	H[50].ptr = P->Magnetics_Ref_Field;
	H[51].ptr = P->Magnetics_Method_Applying_Res_Field;
	H[52].ptr = P->Gravity_Digitizing_Rate;
	H[53].ptr = P->Gravity_Sampling_Rate;
	H[54].ptr = &P->Gravity_Theoretical_Formula_Code;
	H[55].ptr = P->Gravity_Theoretical_Formula;
	H[56].ptr = &P->Gravity_Reference_System_Code;
	H[57].ptr = P->Gravity_Reference_System;
	H[58].ptr = P->Gravity_Corrections_Applied;
	H[59].ptr = P->Gravity_Departure_Base_Station;
	H[60].ptr = P->Gravity_Departure_Base_Station_Name;
	H[61].ptr = P->Gravity_Arrival_Base_Station;
	H[62].ptr = P->Gravity_Arrival_Base_Station_Name;
	H[63].ptr = P->Number_of_Ten_Degree_Identifiers;
	H[64].ptr = P->Ten_Degree_Identifier;
	H[65].ptr = (char *)P->Additional_Documentation;
}
