REM
REM		GMT EXAMPLE 27
REM		$Id: example_27.bat 11641 2013-06-07 00:06:36Z pwessel $
REM
REM Purpose:	Illustrates how to plot Mercator img grids
REM GMT progs:	makecpt, grdgradient, grdimage, grdinfo, pscoast
REM GMT supplement: img2grd (to read Sandwell/Smith img files)
REM DOS calls:	del, grep, $AWK
REM
echo GMT EXAMPLE 27
set ps=example_27.ps

REM Gravity in tasman_grav.nc is in 0.1 mGal increments and the grid
REM is already in projected Mercator x/y units.
REM First get gradients.

gmt grdgradient tasman_grav.nc -Nt1 -A45 -Gtasman_grav_i.nc

REM Make a suitable cpt file for mGal

gmt makecpt -T-120/120/240 -Z -Crainbow > grav.cpt

REM Since this is a Mercator grid we use a linear gmt projection

gmt grdimage tasman_grav.nc=ns/0.1 -Itasman_grav_i.nc -Jx0.25i -Cgrav.cpt -P -K > %ps%

REM Then use gmt pscoast to plot land; get original -R from grid info
REM and use Mercator gmt projection with same scale as above on a spherical Earth

gmt pscoast -R145/170/-50.0163575733/-24.9698584055 -Jm0.25i -Ba10f5 -BWSne -O -K -Gblack --PROJ_ELLIPSOID=Sphere -Cwhite -Dh+ --FORMAT_GEO_MAP=dddF >> %ps%

REM Put a color legend on top of the land mask justified with 147E,31S

echo 147E 31S 1i 2.5i | gmt psxy -R -J -O -K -Sr -D0.25i/0.05i -Gwhite -W1p --PROJ_ELLIPSOID=Sphere >> %ps%
gmt psscale -D0.5i/6.3i/2i/0.15i -Cgrav.cpt -Bx50f10 -By+lmGal -I -O >> %ps%

REM Clean up

del grav.cpt
del *_i.nc
del .gmt*
