#!/usr/bin/python

"""
copy_web_hdf_to_nc4.py

  - converts existing HDF files at the STAR webserver to NetCDF-4
  - given a web directory path, converts the HDF files to NetCDF-4 so that
    the web directory has both HDF and NetCDF-4 versions of the same data
    file
  - imports copy_dir_files_to_newdir.py in order to make use of the
    function export_ncdf (uses cwexport to create a new netCDF-4 file)

input:
  - reads a text listing of web paths
    ( the file containing the text listing is hardcoded below )

usage: ./copy_web_hdf_to_nc4.py

Ron Vogel, SMRC for NOAA CoastWatch
Jan 24, 2017
"""

import sys
#import re
import os
#import shutil
import commands
import copy_dir_files_to_newdir


web_home = '/data/www-socd/mecb/ecn/data'
ecn_disk34 = '/disks/data034/data'
ecn_disk35 = '/disks/data035/data'

# read file to get web server's directories
#     Example list entry:  "mkdir $HOME/modis/k490noaa/daily/ob"
#     ( file is based on make_directories_web.sh ) 
#web_dir_list = open('web_directories.txt', 'r')
#web_dir_list = open('web_directories_TEST.txt', 'r')
#web_dir_list = open('web_directories_PODAAC.txt', 'r')
#web_dir_list = open('web_directories_SST.txt', 'r')
#web_dir_list = open('web_directories_MODIS.txt', 'r')
#web_dir_list = open('web_directories_MODIS_2.txt', 'r')
#web_dir_list = open('web_directories_VIIRS.txt', 'r')
#web_dir_list = open('web_directories_PODAAC_annual.txt', 'r')
web_dir_list = open('ftp_directories_AVHRR_annuals.txt', 'r')

for web_line in web_dir_list:
     web_line_stripd = web_line.strip()      # remove whitespace

     # determine sensor and decide which ECN storage disk contains the data
     dir_items = web_line_stripd.split('/')
     dir_item_one = dir_items[1]
     if dir_item_one == 'modis':
         ecn_disk = ecn_disk34
     else:
         ecn_disk = ecn_disk35

     # determine path to data on web server
     dir_indx = web_line_stripd.find('/')
     web_dir = web_line_stripd[dir_indx:]
     web_path = web_home + web_dir
     ecn_path = ecn_disk + web_dir

     print "Web path: ", web_path

     # test directory exists
     web_path_exists = os.path.exists(web_path)
     if web_path_exists:
         try:
            cmd = './copy_dir_files_to_newdir.py --from_dir ' + ecn_path + ' --to_dir ' + web_path
            (status, output) = commands.getstatusoutput(cmd) # if error, command
                                                    # fails & status is non-zero
            if status:    # status is true (non-zero) upon cmd failure 
               sys.stderr.write(output)  # writes error message
               print '\n'
         except:
            print "Error converting file to netCDF at directory:"
            print "   ", web_path
            print sys.exc_info()[0]
     else:
         print "Problem: the web directory path does not exist"
         print "         ", web_path

web_dir_list.close()

