#!/usr/bin/python

"""
rename_viirs_LOM_monthlies.py

renames files in CW-Central filenaming format to ECN's filenaming format
for VIIRS LOM monthly files

reads all files in given directory, directory name is hardcoded below

overwrites existing file using new filename, i.e. mv command
or
copies existing file to new filename, i.e. cp command


input:   V2014152_2014181_D30_WW00_kdpar.nc

output:  VRSVCW_2014152_MONTHLY_SNPP_KDPAR_GLOBAL_4KM.nc

usage:   ./rename_viirs_LOM_monthlies.py


Ron Vogel, SMRC for NOAA CoastWatch
Dec 6, 2017
"""

import sys
#import re
import os
import shutil
#import commands


inputdir = '/disks/data035/data/viirs/kdpar_4km/monthly/global'

files = os.listdir(inputdir)


for file in files:

#   print file

   yrday = file[1:8]

   newfile = 'VRSVCW_' + yrday + '_MONTHLY_SNPP_KDPAR_GLOBAL_4KM.nc'
#   print newfile

   shutil.move(inputdir+'/'+file,inputdir+'/'+newfile)
#   shutil.copy(inputdir+'/'+file,inputdir+'/'+newfile)


