#!/data/home004/ronald.vogel/.conda/envs/rv_pip_installs/bin/python3

"""
replace_value_in_netcdf_variable_for_erddap.py

replaces the value in a netcdf variable for all data files in a directory
e.g. all files in a time series

used for replacing time value and time units in the 'time' variable 
for climatologies because ERDDAP does not interpret climatology time series 
like other time series
   - each file in the climatology needs to have a consecutive _count_ value 
     in the time variable rather than a date value
   - the units attribute of the time variable need to be units of 'count'
   - the time_bounds attribute is no longer applicable because the time
     value is only a single value (not a range of 2 values), so time_bounds
     needs to be deleted
   - also (but not with this code) the name of the time variable name needs
     to change from 'time' to 'DayOfYear', or 'WeekOfYear', etc
     and the count range for the whole dataset need to be indicated (e.g.
     1,365 or 1,52). These are done in the datasets.xml, see datasets.xml 
     examples for climatology data sets.

currently written to work on weekly (7day) climatology files

Python netCDF4 methodology from Dale Robinson, CW WCN

Ron Vogel, UMD/ESSIC for NOAA CoastWatch
Nov 16, 2023
"""

import netCDF4
import os
import subprocess
import glob


#main_dir = '/data/aftp/socd1/ecn/data/viirs/chl/7day_climatol'
main_dir = '/data/aftp/socd1/ecn/data/avhrr-viirs/sst-ngt/7day_climatol'
#sub_dir = 'ec_median_2012-2022_minus20132019'
#sub_dir = 'ec_median_2012-2022_minus2019'
sub_dir = 'ec_erddap_convertTime'

week_start = ["001", "008", "015", "022", "029", "036", "043", "050", "057", "064", "071", "078", "085", "092", "099", "106", "113", "120", "127", "134", "141", "148", "155", "162", "169", "176", "183", "190", "197", "204", "211", "218", "225", "232", "239", "246", "253", "260", "267", "274", "281", "288", "295", "302", "309", "316", "323", "330", "337", "344", "351", "358"]

dir = os.path.join(main_dir,sub_dir)
print("File Dir: " + dir)
  
#filelist = os.listdir(dir)
#filelist = glob.glob(dir + '/VRSRCW_*.nc')
filelist = glob.glob(dir + '/ACSPOCW_7DAY-*.nc')
#print("File List: " + str(sorted(filelist)))

filelist=sorted(filelist)
print("First file: " + str(filelist[0]))
print("Last file: " + str(filelist[-1]))
print(" ")

for file in filelist:

   # filename from filelist
   print(file)
   filename = os.path.basename(file)

   #doy = filename[12:15]
   doy = filename[13:16]
   print(" Doy: " + str(doy))

   for i in range(0,51+1):
   #for i in range(0,0+1):
   #for i in range(1,51+1):

      week = week_start[i]

      if week == doy:

         print("   Week: ", week)

         newval = int(i+1)

         dir_file = os.path.join(dir,filename)

         # Rename and copy the data file to align the data file
         # with the HDF library on system
         # - because the Python netCDF module commands were not modifying the
         #   the file's variable correctly
         # (per Dale's 11/22/2023 email in 'climatology dataset for ERDDAP'
         # email thread)
         dir_file_temp = os.path.join(dir,'temp.nc')
         os.rename(dir_file, dir_file_temp)
         myCmd = 'nccopy ' + dir_file_temp + ' ' + dir_file
         print('zero is success for nccopy: ', subprocess.call(myCmd, shell=True))
         os.remove(dir_file_temp)

         # Now make the modifications to the variable
         nc_file = netCDF4.Dataset(dir_file, "a")
         t = nc_file['time']
         #print("   t: " + str(t))
         #print(" ")
         print("   Standard Name: ", t.standard_name)
         print("   Units: ", t.units)
         timeval = t[:]
         print("   Time value: ", str(timeval))
         print(" ")

         # change time units to 'count'
         t.units = 'count'
         # change time value to consecutive count of the 
         # climatology's time slices
         t[:] = newval
         # remove the bounds attribute, not valid with the new time value
         del t.bounds

         print("     new Units: ", t.units)
         print("     new Time value: ", t[:])
         print(" ")
         print(" ")

         nc_file.close() 

