; VIIRS Enterprise aerosol retrieval data

tmp ={VAVAR, $
      dataType:0B, $ ; data type: 0: categorical integer value  
                     ;            1: continuous floating-point value 
      dataGrp: 0B, $ ; 0:Baseline AOD outputs 
                     ; 1:Baseline ADP outputs
                     ; 2:Cloud Mask
                     ; 3:GMTCO
                     ; 4:SDR : NN4, where NN is the channel number, for example B1 is 14, B15 is 154
      name:'', $     ; variable name 
      dataSetIdx: 0, $        ; index of dataset 
      dataRange:FLTARR(2), $  ; data range
      imageTitle:'', $        ; title shown in image
      nLevels:0, $            ; number of major mark intervals in colorbar
      annotation:Ptr_New()}   ; annontation
    
      
nullPtr = Ptr_New()
biAnnPtr = Ptr_New(['False','True'])
ynAnnPtr = Ptr_New(['No','Yes'])
biCldAnnPtr = Ptr_New(['Clear','Cloudy'])
qcAnnPtr = Ptr_New(['Good','Bad'])
adpQcPtr=Ptr_New(['Performed','Not Performed'])
adpConfPtr=Ptr_New(['Low','','Medium','High'])
cdQcPtr=Ptr_New(['Good', 'Invalid_Alg', 'Degraded_LZA', 'Invalid_11um', 'Degraded_3.9um', 'Degraded_0.64um', 'Degraded_Other'])

DATA_AOD = 0B   ; keep this sequence for later updates
DATA_ADP = 1B 
DATA_CLDMSK = 2B
DATA_GEO = 3B
DATA_SDR = 4B

NVar = [2,7,2,6,21]
NDataset = [2,4,2,6,21] 

NVars = TOTAL(NVar)
NDataSets = TOTAL(NDataset)

abiAerVar = Replicate({VAVAR}, NVars)

; lon/lat (from static files) are not listed here
  
;===== AOD outputs =====

abiAerVar[0] = {VAVAR,1B,DATA_AOD,'AOD',0,[0.,1.],'AOD at 550nm',10,nullPtr}
abiAerVar[1] = {VAVAR,0B,DATA_AOD,'DQF',1,[0,2],'AOD Retrieval Quality',2, qcAnnPtr}
  
;===== ADP outputs (optional) =====

NV = NVar[0]
ND = NDataset[0]
abiAerVar[NV]   = {VAVAR,0B,DATA_ADP,'Aerosol',ND,[0,2],'Aerosol Flag',2,ynAnnPtr}
abiAerVar[NV+1] = {VAVAR,0B,DATA_ADP,'Dust',ND+1,[0,2],'Dust Flag',2,ynAnnPtr}
abiAerVar[NV+2] = {VAVAR,0B,DATA_ADP,'Smoke',ND+2,[0,2],'Smoke Flag',2,ynAnnPtr}
abiAerVar[NV+3] = {VAVAR,0B,DATA_ADP,'DQF@0',ND+3,[0,2],'Smoke Detection Flag',2,adpQcPtr}
abiAerVar[NV+4] = {VAVAR,0B,DATA_ADP,'DQF@1',ND+3,[0,2],'Dust Detection Flag',2,adpQcPtr}
abiAerVar[NV+5] = {VAVAR,0B,DATA_ADP,'DQF@2@3',ND+3,[0,4],'Smoke Detection Confidence',4,adpConfPtr}
abiAerVar[NV+6] = {VAVAR,0B,DATA_ADP,'DQF@4@5',ND+3,[0,4],'Dust Detection Confidence',4,adpConfPtr}

;===== Cloud Mask (optional) =====

NV = TOTAL(NVar[0:1])
ND = TOTAL(NDataset[0:1])
abiAerVar[NV] = {VAVAR,0B,DATA_CLDMSK,'BCM',ND,[0,2],'Cloud Mask',2,bicldAnnPtr}
abiAerVar[NV+1] = {VAVAR,0B,DATA_CLDMSK,'DQF',ND+1,[0,7],'Cloud Mask Quality',7,cdQcPtr}

;===== Geometry (optional) =====

NV = TOTAL(NVar[0:2])
ND = TOTAL(NDataset[0:2])

abiAerVar[NV]   = {VAVAR,1B,DATA_GEO,'SZA',ND,[0.,90.],'Solar Zenith Angle [Degree]',9,nullPtr}
abiAerVar[NV+1] = {VAVAR,1B,DATA_GEO,'SatZen2KM',ND+1,[0.,90.],'Satellite Zenith Angle [Degree]',9,nullPtr} 
abiAerVar[NV+2] = {VAVAR,1B,DATA_GEO,'SAA',ND+2,[0.,360.],'Solar Azimuth Angle [Degree]',9,nullPtr}
abiAerVar[NV+3]  = {VAVAR,1B,DATA_GEO,'SatAzi2KM',ND+3,[0.,360.],'Satellite Azimuth Angle [Degree]',9,nullPtr}
abiAerVar[NV+4]  = {VAVAR,1B,DATA_GEO,'RELAZ',ND+4,[0.,180.],'Relative Azimuth Angle [Degree]',9,nullPtr}
abiAerVar[NV+5]  = {VAVAR,1B,DATA_GEO,'SCAT',ND+5,[0.,180.],'Scattering Angle [Degree]',9,nullPtr}

;=====  SDR (optional 2KM) =====

NV = TOTAL(NVar[0:3])
ND = TOTAL(NDataset[0:3])
sdr_qf_quality_ptr = Ptr_New(['Good','Conditional','OutOfRange','NoValue'])

; Band 1
abiAerVar[NV]    = {VAVAR,1B,10B+DATA_SDR,'REFL',ND,[0., 0.5],'Band1 (0.47um) Reflectance',10,nullPtr}
abiAerVar[NV+1]  = {VAVAR,0B,10B+DATA_SDR,'DQF',ND+1,[0,4],'Band1 Refl Quality',4,sdr_qf_quality_ptr}
; Band 2
abiAerVar[NV+2]  = {VAVAR,1B,20B+DATA_SDR,'REFL',ND+2,[0., 0.5],'Band2 (0.64um) Reflectance',10,nullPtr}
abiAerVar[NV+3]  = {VAVAR,0B,20B+DATA_SDR,'DQF',ND+3,[0,4],'Band2 Refl Quality',4,sdr_qf_quality_ptr}
; Band 3
abiAerVar[NV+4]  = {VAVAR,1B,30B+DATA_SDR,'REFL',ND+4,[0., 0.5],'Band3 (0.865um) Reflectance',10,nullPtr}
abiAerVar[NV+5]  = {VAVAR,0B,30B+DATA_SDR,'DQF',ND+5,[0,4],'Band3 Refl Quality',4,sdr_qf_quality_ptr}
; Band 4
abiAerVar[NV+6]  = {VAVAR,1B,40B+DATA_SDR,'REFL',ND+6,[0., 0.5],'Band4 (1.378um) Reflectance',10,nullPtr}
abiAerVar[NV+7]  = {VAVAR,0B,40B+DATA_SDR,'DQF',ND+7,[0,4],'Band4 Refl Quality',4,sdr_qf_quality_ptr}
; Band 5
abiAerVar[NV+8]  = {VAVAR,1B,50B+DATA_SDR,'REFL',ND+8,[0., 0.5],'Band5 (1.61um) Reflectance',10,nullPtr}
abiAerVar[NV+9]  = {VAVAR,0B,50B+DATA_SDR,'DQF',ND+9,[0,4],'Band5 Refl Quality',4,sdr_qf_quality_ptr}
; Band 6
abiAerVar[NV+10] = {VAVAR,1B,60B+DATA_SDR,'REFL',ND+10,[0., 0.5],'Band6 (2.25um) Reflectance',10,nullPtr}
abiAerVar[NV+11] = {VAVAR,0B,60B+DATA_SDR,'DQF',ND+11,[0,4],'Band6 Refl Quality',4,sdr_qf_quality_ptr}
; Band 11
abiAerVar[NV+12] = {VAVAR,1B,110B+DATA_SDR,'CMI',ND+12,[250.,300.],'Band11 (8.5um) Brightness Temperature',10,nullPtr}
abiAerVar[NV+13] = {VAVAR,0B,110B+DATA_SDR,'DQF',ND+13,[0,4],'Band11 BT Quality',4,sdr_qf_quality_ptr}
; Band 14
abiAerVar[NV+14] = {VAVAR,1B,140B+DATA_SDR,'CMI',ND+14,[250.,300.],'Band14 (11.2um) Brightness Temperature',10,nullPtr}
abiAerVar[NV+15] = {VAVAR,0B,140B+DATA_SDR,'DQF',ND+15,[0,4],'Band14 BT Quality',4,sdr_qf_quality_ptr}
; Band 15
abiAerVar[NV+16] = {VAVAR,1B,150B+DATA_SDR,'CMI',ND+16,[250.,300.],'Band15 (12.3um) Brightness Temperature',10,nullPtr}
abiAerVar[NV+17] = {VAVAR,0B,150B+DATA_SDR,'DQF',ND+17,[0,4],'Band15 BT Quality',4,sdr_qf_quality_ptr}

; RGBs
abiAerVar[NV+18] = {VAVAR,1B,DATA_SDR,'SyncRGB',ND+18,[0., 1.],'Synthetic RGB',10,nullPtr}
abiAerVar[NV+19] = {VAVAR,1B,DATA_SDR+1,'DustRGB',ND+19,[0., 1.],'Dust RGB',10,nullPtr}
abiAerVar[NV+20] = {VAVAR,1B,DATA_SDR+2,'NatlRGB',ND+20,[0., 1.],'Natural RGB',10,nullPtr}

