;
; Procedure used to detect and delete problematic HDF5 files
;
; Input:
;   dataPath: directory where HDF5 files locate (no subdirecties)
;
; Optional Input:  
;   logFile: name of a log file containing the deleted HDF5 file names
;            If not provided, 'delete_files.log' is used
; Output:
;   No output if all HDF5 files are valid, 
;   otherwise, generate the logFile containing the deleted HDF5 file names
;
; Calling sequence:
;   Check_H5F, '/data/data003/GRAVITE/NPP/data/GMTCO/2012004/', LOGFILE='GMTCO_2012004.inv'
;

FUNCTION Is_H5F_Invalid, fileName
  CATCH, error
  IF (error NE 0L) THEN BEGIN
    CATCH, /CANCEL
    ;PRINT, !ERROR_STATE
    RETURN, 1
  ENDIF
  
  ;IF ~H5F_IS_HDF5(fileName) THEN RETURN, 1
  IF (fid=H5F_OPEN(fileName)) GT 0 THEN $
     H5F_CLOSE, fid
  
  RETURN, 0
END

PRO Reverse_Check_H5F, dataPath
   
   IF StrMid(dataPath, StrLen(dataPath)-1,1) NE '/' THEN $
      dataPath = dataPath + '/'
      
   h5Files = File_Search(dataPath+'*.h5.part', COUNT=nf)
   IF nf EQ 0 THEN RETURN
   FOR i=0,nf-1 DO BEGIN
      File_Move, h5Files[i], StrMid(h5Files[i],0,StrLen(h5Files[i])-5)
   ENDFOR
END


PRO Check_H5F, dataPath, LOGFILE=logFile
   ON_ERROR, 2
   IF N_Elements(logFile) EQ 0 THEN logFile = 'delete_files.log'
   IF StrMid(dataPath, StrLen(dataPath)-1,1) NE '/' THEN $
      dataPath = dataPath + '/'
   
   h5Files = File_Search(dataPath+'*.h5', COUNT=nf)
   IF nf EQ 0 THEN RETURN
   nInvFile = 0
   FOR i=0,nf-1 DO BEGIN
      IF Is_H5F_Invalid(h5Files[i]) THEN BEGIN
dummy = File_Search(dataPath+'*.h5', COUNT=nn)
IF nn EQ 0 THEN BEGIN
PRINT,'!!!!'  
stop
ENDIF
         ;File_Delete, h5Files[i], /QUIET
         File_Move, h5Files[i], h5Files[i]+'.part'
         nInvFile = nInvFile + 1
         IF nInvFile EQ 1 THEN BEGIN
            IF File_Test(logFile) THEN File_Delete, logFile
            OpenW, lun, /Get_Lun, logFile
         ENDIF
         PrintF, lun, h5Files[i] 
      ENDIF
   ENDFOR
   
   IF nInvFile GT 0 THEN BEGIN
      CLOSE, lun
      FREE_LUN, lun
   ENDIF 
END
