

FUNCTION Normalize, range, Position=position

    ; This is a utility function to calculate the scale factor
    ; required to position a vector of specified range at a
    ; specific position given in normalized coordinates.

IF (N_Elements(position) EQ 0) THEN position = [0.0, 1.0]

scale = [((position[0]*range[1])-(position[1]*range[0])) / $
    (range[1]-range[0]), (position[1]-position[0])/(range[1]-range[0])]

RETURN, scale
END
;-------------------------------------------------------------------------


FUNCTION ColorBar::INIT, Position=position, $
    NColors=ncolors, Title=title, Palette=palette, $
    Major=major, Minor=minor, Range=range, Color=color, $
    _Extra=extra, Name=name, tickName=tickName

   ; Catch possible errors.

Catch, theError
IF theError NE 0 THEN BEGIN
   Catch, /Cancel
   ok = Dialog_Message(!Error_State.Msg)
   Message, !Error_State.Msg, /Informational
   RETURN, 0
ENDIF

   ; Initialize model superclass.

IF (self->IDLgrModel::Init(_EXTRA=extra) NE 1) THEN RETURN, 0

    ; Define default values for keywords, if necessary.

IF N_Elements(name) EQ 0 THEN name=''
IF N_Elements(color) EQ 0 THEN self.color = [255,255,255] $
   ELSE self.color = color
thisFont = Obj_New('IDLgrFont', 'Helvetica', Size=10.0)
self.thisFont = thisFont
IF N_Elements(title) EQ 0 THEN title=''

thisTitle = Obj_New('IDLgrText', title, Color=self.color, $
    Font=thisFont, Recompute_Dimensions=2)

IF N_Elements(ncolors) EQ 0 THEN self.ncolors = 256 $
   ELSE self.ncolors = ncolors
IF N_Elements(palette) EQ 0 THEN BEGIN
    red = (green = (blue = BIndGen(self.ncolors)))
    self.palette = Obj_New('IDLgrPalette', red, green, blue)
ENDIF ELSE self.palette = palette
IF N_Elements(range) EQ 0 THEN self.range = [0, self.ncolors] $
   ELSE self.range = range
IF N_Elements(major) EQ 0 THEN self.major = -1 $
   ELSE self.major = major
IF N_Elements(minor) EQ 0 THEN self.minor = 0 $
   ELSE self.minor = minor
IF N_Elements(position) EQ 0 THEN self.position = [0.90, 0.10, 0.95, 0.90] $
   ELSE self.position = position

    ; Create the colorbar image. Get its size.

IF (position[2]-position[0]) LT (position[3]-position[1]) THEN BEGIN 

   ; Vertical color bar

   IF self.ncolors LT 127 THEN $
     bar = REPLICATE(1B,10) # REBIN(BINDGEN(self.ncolors),256/self.ncolors*self.ncolors) $ 
   ELSE bar = REPLICATE(1B,10) # BINDGEN(self.ncolors)
   
   shortAxis1Loc=[1000, self.position(1), 0.001]
   shortAxis2Loc=[1000, self.position(3), 0.001]
   textAxisLoc  =[self.position(0), 1000, 0.001]
   longAxis2Loc =[self.position(2), 1000, 0.001]
   longScale = Normalize(self.range, Position=[self.position(1), self.position(3)])
   shortScale = Normalize([0,1], Position=[self.position(0), self.position(2)])
   
   shortAxis1 = Obj_New("IDLgrAxis", 0, Color=self.color, Ticklen=0.0, $
                         Major=0, Range=[0,1], /NoText, /Exact, XCoord_Conv=shortScale,  $
                         Location=shortAxis1Loc)
   shortAxis2 = Obj_New("IDLgrAxis", 0, Color=self.color, Ticklen=0.0, $
                         Major=0, Range=[0,1], /NoText, /Exact, XCoord_Conv=shortScale,  $
                         Location=shortAxis2Loc, TickDir=1)

   IF N_Elements(tickName) GT 0 THEN BEGIN
      thisText = Obj_New('IDLgrText', tickName)
      tickValue = INDGEN(self.ncolors)+0.5+self.range[0]
      textAxis = Obj_New("IDLgrAxis", 1, Color=self.color, Ticklen=0.0, $
                       Major=self.major, Minor=self.minor, Title=thisTitle, $
                       Range=self.range, /Exact, $
                       TICKVALUES=tickValue, TICKTEXT=thisText, $   
                       YCoord_Conv=longScale, Location=textAxisLoc)
      thisText->SetProperty, Font=self.thisFont, Recompute_Dimensions=2
      longAxis2 = Obj_New("IDLgrAxis", 1, Color=self.color, /NoText, Ticklen=0, $
                       Major=self.major, Minor=self.minor, Range=self.range, TickDir=1, $
                       YCoord_Conv=longScale, Location=longAxis2Loc, /Exact)
   ENDIF ELSE BEGIN
      textAxis = Obj_New("IDLgrAxis", 1, Color=self.color, Ticklen=0.0, $
                         Major=self.major, Minor=self.minor, Title=thisTitle, $
                         Range=self.range, /Exact, $
                         YCoord_Conv=longScale, Location=textAxisLoc)
      textAxis->GetProperty, TickText=thisText
      thisText->SetProperty, Font=self.thisFont, Recompute_Dimensions=2
      tickLen=self.position[2]-self.position[0]
      longAxis2 = Obj_New("IDLgrAxis", 1, Color=self.color, /NoText, Ticklen=tickLen, $
                       Major=self.major, Minor=self.minor, Range=self.range, TickDir=1, $
                       YCoord_Conv=longScale, Location=longAxis2Loc, /Exact)
   ENDELSE
ENDIF ELSE BEGIN   

   ; horizontal color bar   
   
   IF self.ncolors LT 127 THEN $
     bar = REPLICATE(1B,10) ## REBIN(BINDGEN(self.ncolors),256/self.ncolors*self.ncolors) $ 
   ELSE bar = REPLICATE(1B,10) ## BINDGEN(self.ncolors)
   
   shortAxis1Loc=[self.position(0), 1000, 0.001]
   shortAxis2Loc=[self.position(2), 1000, 0.001]
   textAxisLoc  =[1000, self.position(1), 0.001]
   longAxis2Loc =[1000, self.position(3), 0.001]
   longScale = Normalize(self.range, Position=[self.position(0), self.position(2)])
   shortScale = Normalize([0,1], Position=[self.position(1), self.position(3)])
   
   shortAxis1 = Obj_New("IDLgrAxis", 1, Color=self.color, Ticklen=0.0, $
                         Major=0, Range=[0,1], /NoText, /Exact, YCoord_Conv=shortScale,  $
                         Location=shortAxis1Loc)
   shortAxis2 = Obj_New("IDLgrAxis", 1, Color=self.color, Ticklen=0.0, $
                         Major=0, Range=[0,1], /NoText, /Exact, YCoord_Conv=shortScale,  $
                         Location=shortAxis2Loc, TickDir=1)

   IF N_Elements(tickName) GT 0 THEN BEGIN
      thisText = Obj_New('IDLgrText', tickName)
      tickValue = INDGEN(self.ncolors)+0.5+self.range[0]
      textAxis = Obj_New("IDLgrAxis", 0, Color=self.color, Ticklen=0.0, $
                       Major=self.major, Minor=self.minor, Title=thisTitle, $
                       Range=self.range, /Exact, $
                       TICKVALUES=tickValue, TICKTEXT=thisText, $   
                       XCoord_Conv=longScale, Location=textAxisLoc)
      thisText->SetProperty, Font=self.thisFont, Recompute_Dimensions=2
      longAxis2 = Obj_New("IDLgrAxis", 0, Color=self.color, /NoText, Ticklen=0, $
                       Major=self.major, Minor=self.minor, Range=self.range, TickDir=1, $
                       XCoord_Conv=longScale, Location=longAxis2Loc, /Exact)
   ENDIF ELSE BEGIN
      textAxis = Obj_New("IDLgrAxis", 0, Color=self.color, Ticklen=0.0, $
                         Major=self.major, Minor=self.minor, Title=thisTitle, $
                         Range=self.range, /Exact, $
                         XCoord_Conv=longScale, Location=textAxisLoc)
      textAxis->GetProperty, TickText=thisText
      thisText->SetProperty, Font=self.thisFont, Recompute_Dimensions=2
      tickLen=self.position[3]-self.position[1]
      longAxis2 = Obj_New("IDLgrAxis", 0, Color=self.color, /NoText, Ticklen=tickLen, $
                       Major=self.major, Minor=self.minor, Range=self.range, TickDir=1, $
                       XCoord_Conv=longScale, Location=longAxis2Loc, /Exact)
   ENDELSE
ENDELSE
s = SIZE(bar, /Dimensions)
xsize = s[0]
ysize = s[1]

    ; Create the colorbar image object. Add palette to it.

thisImage = Obj_New('IDLgrImage', bar, Palette=self.palette)
xs = Normalize([0,xsize], Position=[0,1.])
ys = Normalize([0,ysize], Position=[0,1.])
thisImage->SetProperty, XCoord_Conv=xs, YCoord_Conv=ys

   ; Create a polygon object. Add the image as a texture map. We do
   ; this so the image can rotate in 3D space.

thisPolygon = Obj_New('IDLgrPolygon', [0, 1, 1, 0], [0, 0, 1, 1], [0,0,0,0], $
   Texture_Map=thisImage, Texture_Coord = [[0,0], [1,0], [1,1], [0,1]], color=[255,255,255])

    ; Scale the polygon into the correct position.

xs = Normalize([0,1], Position=[self.position(0), self.position(2)])
ys = Normalize([0,1], Position=[self.position(1), self.position(3)])
thispolygon->SetProperty, XCoord_Conv=xs, YCoord_Conv=ys

    ; Add the parts to the colorbar model.

self->Add, shortAxis1
self->Add, shortAxis2
self->Add, textAxis
self->Add, longAxis2
self->Add, thisPolygon

   ; Assign the name.

self->IDLgrModel::SetProperty, Name=name, Select_Target=1

    ; Create a container object and put the objects into it.

thisContainer = Obj_New('IDL_Container')
thisContainer->Add, thisFont
thisContainer->Add, thisImage
thisContainer->Add, thisText
thisContainer->Add, thisTitle
thisContainer->Add, self.palette
thisContainer->Add, textAxis
thisContainer->Add, shortAxis1
thisContainer->Add, shortAxis2
thisContainer->Add, longAxis2

    ; Update the SELF structure.

self.thisImage = thisImage
self.thisFont = thisFont
self.thisText = thisText
self.textAxis = textAxis
self.shortAxis1 = shortAxis1
self.shortAxis2 = shortAxis2
self.longAxis2 = longAxis2
self.thisContainer = thisContainer
self.thisTitle = thisTitle

RETURN, 1
END
;-------------------------------------------------------------------------



PRO ColorBar::Cleanup

    ; Lifecycle method to clean itself up.

Obj_Destroy, self.thisContainer
self->IDLgrMODEL::Cleanup
END
;-------------------------------------------------------------------------



PRO ColorBar::GetProperty, Position=position, Text=text, $
    Title=title, Palette=palette, Major=major, Minor=minor, $
    Range=range, Color=color, Name=name, $
    Transform=transform, _Ref_Extra=extra

    ; Get the properties of the colorbar.

IF Arg_Present(position) THEN position = self.position
IF Arg_Present(text) THEN text = self.thisText
IF Arg_Present(title) THEN self.thisTitle->GetProperty, Strings=title
IF Arg_Present(palette) THEN palette = self.palette
IF Arg_Present(major) THEN major = self.major
IF Arg_Present(minor) THEN minor = self.minor
IF Arg_Present(range) THEN range = self.range
IF Arg_Present(color) THEN color = self.color
IF Arg_Present(name) THEN self->IDLgrMODEL::GetProperty, Name=name
IF Arg_Present(transform) THEN self->IDLgrMODEL::GetProperty, Transform=transform
IF Arg_Present(extra) THEN self->IDLgrMODEL::GetProperty, _Extra=extra

END
;-------------------------------------------------------------------------



PRO ColorBar::SetProperty, Position=position, $
    Title=title, Palette=palette, Major=major, Minor=minor, $
    Range=range, Color=color, Name=name, Transform=transform, _Extra=extra

    ; Set properties of the colorbar.

IF N_Elements(position) NE 0 THEN BEGIN
    self.position = position

        ; Find the size of the image.

    self.thisImage->GetProperty, Data=image
    s = Size(image)
    xsize = s(1)
    ysize = s(2)
    xs = Normalize([0,xsize], Position=[position(0), position(2)])
    ys = Normalize([0,ysize], Position=[position(1), position(3)])
    self.thisImage->SetProperty, XCoord_Conv=xs, YCoord_Conv=ys

        ; Create new scale factors to position the axes.

    longScale = Normalize(self.range, $
       Position=[self.position(1), self.position(3)])
    shortScale = Normalize([0,1], $
       Position=[self.position(0), self.position(2)])

        ; Position the axes. 1000 indicates this position ignored.

    self.textaxis->SetProperty, YCoord_Conv=longScale, $
       Location=[self.position(0), 1000, 0]
    self.longaxis2->SetProperty, YCoord_Conv=longScale, $
       Location=[self.position(2), 1000, 0]
    self.shortAxis1->SetProperty, XCoord_Conv=shortScale, $
       Location=[1000, self.position(1), 0]
    self.shortAxis2->SetProperty, XCoord_Conv=shortScale, $
       Location=[1000, self.position(3), 0]

ENDIF
IF N_Elements(title) NE 0 THEN self.thisTitle->SetProperty, Strings=title
IF N_Elements(transform) NE 0 THEN self->IDLgrMODEL::SetProperty, Transform=transform
IF N_Elements(palette) NE 0 THEN BEGIN
    self.palette = palette
    self.thisImage->SetProperty, Palette=palette
ENDIF
IF N_Elements(major) NE 0 THEN BEGIN
    self.major = major
    self.textAxis->SetProperty, Major=major
    self.longAxis2->SetProperty, Major=major
END
IF N_Elements(minor) NE 0 THEN BEGIN
    self.minor = minor
    self.textAxis->SetProperty, Minor=minor
    self.longAxis2->SetProperty, Minor=minor
END
IF N_Elements(range) NE 0 THEN BEGIN
    self.range = range
    longScale = Normalize(range, $
       Position=[self.position(1), self.position(3)])
    self.textAxis->SetProperty, Range=range, YCoord_Conv=longScale
    self.longAxis2->SetProperty, Range=range, YCoord_Conv=longScale
ENDIF
IF N_Elements(color) NE 0 THEN BEGIN
    self.color = color
    self.textAxis->SetProperty, Color=color
    self.longAxis2->SetProperty, Color=color
    self.shortAxis1->SetProperty, Color=color
    self.shortAxis2->SetProperty, Color=color
    self.thisText->SetProperty, Color=color
ENDIF
IF N_Elements(name) NE 0 THEN self->IDLgrMODEL::SetProperty, Name=name
IF N_Elements(extra) NE 0 THEN self->IDLgrMODEL::SetProperty, _Extra=extra
END
;-------------------------------------------------------------------------



PRO ColorBar__Define

colorbarinfo = { COLORBAR, $
             INHERITS IDLgrMODEL, $      ; Inherits the Model Object.
             Position:FltArr(4), $       ; The position of the colorbar.
             Palette:Obj_New(), $        ; The colorbar palette.
             thisImage:Obj_New(), $      ; The colorbar image.
             imageModel:Obj_New(), $     ; The colorbar image model.
             thisContainer:Obj_New(), $  ; Container for cleaning up.
             thisFont:Obj_New(), $       ; The annotation font object.
             thisText:Obj_New(), $       ; The bar annotation text object.
             thisTitle: Obj_New(), $     ; The title of the colorbar.
             textAxis:Obj_New(), $       ; The axis containing annotation.
             shortAxis1:Obj_New(), $     ; A short axis.
             shortAxis2:Obj_New(), $     ; A second short axis.
             longAxis2:Obj_New(), $      ; The other long axis.
             NColors:0, $                ; The number of colors in the bar.
             Major:0, $                  ; Number of major axis intervals.
             Minor:0, $                  ; Number of minor axis intervals.
             Color:BytArr(3), $          ; Color of axes and annotation.
             Range:FltArr(2) }           ; The range of the colorbar axis.

END
;-------------------------------------------------------------------------

